(function ($) {
    'use strict';
    if ($.validator) {
        $.validator.messages = $.extend({}, $.validator.messages, {
            required: '<?php echo e(__tr("This field is required.")); ?>',
            remote: '<?php echo e(__tr("Please fix this field.")); ?>',
            email: '<?php echo e(__tr("Please enter a valid email address.")); ?>',
            url: '<?php echo e(__tr("Please enter a valid URL.")); ?>',
            date: '<?php echo e(__tr("Please enter a valid date.")); ?>',
            dateISO: '<?php echo e(__tr("Please enter a valid date (ISO).")); ?>',
            number: '<?php echo e(__tr("Please enter a valid number.")); ?>',
            digits: '<?php echo e(__tr("Please enter only digits.")); ?>',
            equalTo: '<?php echo e(__tr("Please enter the same value again.")); ?>',
            maxlength: $.validator.format('<?php echo e(__tr("Please enter no more than {0} characters.")); ?>'),
            minlength: $.validator.format('<?php echo e(__tr("Please enter at least {0} characters.")); ?>'),
            rangelength: $.validator.format('<?php echo e(__tr("Please enter a value between {0} and {1} characters long.")); ?>'),
            range: $.validator.format('<?php echo e(__tr("Please enter a value between {0} and {1}.")); ?>'),
            max: $.validator.format('<?php echo e(__tr("Please enter a value less than or equal to {0}.")); ?>'),
            min: $.validator.format('<?php echo e(__tr("Please enter a value greater than or equal to {0}.")); ?>'),
            step: $.validator.format('<?php echo e(__tr("Please enter a multiple of {0}.")); ?>')
        });
    }
    if ($.fn.dataTable) {
        $.fn.dataTable.defaults = $.extend({}, $.fn.dataTable.defaults, {
            "language": {
                /* url: 'https://cdn.datatables.net/plug-ins/1.11.5/i18n/<?php echo e(app()->getLocale()); ?>.json', */
                "decimal": "",
                "emptyTable": '<?php echo e(__tr("No data available in table")); ?>',
                "info": '<?php echo e(__tr("Showing _START_ to _END_ of _TOTAL_ entries")); ?>',
                "infoEmpty": "<?php echo e(__tr('Showing 0 to 0 of 0 entries')); ?>",
                "infoFiltered": "<?php echo e(__tr('(filtered from _MAX_ total entries)')); ?>",
                "infoPostFix": "",
                "thousands": ",",
                "lengthMenu": "<?php echo e(__tr('Show _MENU_ entries')); ?>",
                "loadingRecords": "<?php echo e(__tr('Loading...')); ?>",
                "processing": '<?php echo e(__tr("Processing...")); ?>',
                "search": "<?php echo e(__tr('Search:')); ?>",
                "zeroRecords": "<?php echo e(__tr('No matching records found')); ?>",
                "paginate": {
                    "first": "<?php echo e(__tr('First')); ?>",
                    "last": "<?php echo e(__tr('Last')); ?>",
                    "next": "<?php echo e(__tr('Next')); ?>",
                    "previous": "<?php echo e(__tr('Previous')); ?>"
                },
                "aria": {
                    "sortAscending": "<?php echo e(__tr(': activate to sort column ascending')); ?>",
                    "sortDescending": "<?php echo e(__tr(': activate to sort column descending')); ?>"
                }
            }
            /* language: {
                url: 'https://cdn.datatables.net/plug-ins/1.11.5/i18n/mr.json'
            } */
        });
    }

    if($('input.lw-date-range-picker').length) {
        $('input.lw-date-range-picker').each(function(index, element) {
            $(element).daterangepicker({
                "startDate": $(element).data('startDate'),
                "endDate": $(element).data('endDate'),
                locale : {
                    "format": "YYYY-MM-DD",
                    "separator": " - ",
                    "applyLabel": "<?php echo e(__tr('Apply')); ?>",
                    "cancelLabel": "<?php echo e(__tr('Cancel')); ?>",
                    "fromLabel": "<?php echo e(__tr('From')); ?>",
                    "toLabel": "<?php echo e(__tr('To')); ?>",
                    "customRangeLabel": "<?php echo e(__tr('Custom')); ?>",
                    "weekLabel": "<?php echo e('W'); ?>",
                    "daysOfWeek": [
                        "<?php echo e(__tr('Su')); ?>",
                        "<?php echo e(__tr('Mo')); ?>",
                        "<?php echo e(__tr('Tu')); ?>",
                        "<?php echo e(__tr('We')); ?>",
                        "<?php echo e(__tr('Th')); ?>",
                        "<?php echo e(__tr('Fr')); ?>",
                        "<?php echo e(__tr('Sa')); ?>"
                    ],
                    "monthNames": [
                        "<?php echo e(__tr('January')); ?>",
                        "<?php echo e(__tr('February')); ?>",
                        "<?php echo e(__tr('March')); ?>",
                        "<?php echo e(__tr('April')); ?>",
                        "<?php echo e(__tr('May')); ?>",
                        "<?php echo e(__tr('June')); ?>",
                        "<?php echo e(__tr('July')); ?>",
                        "<?php echo e(__tr('August')); ?>",
                        "<?php echo e(__tr('September')); ?>",
                        "<?php echo e(__tr('October')); ?>",
                        "<?php echo e(__tr('November')); ?>",
                        "<?php echo e(__tr('December')); ?>"
                    ],
                    // "firstDay": 1
                },
                ranges: {
                    '<?php echo e(__tr("Today")); ?>': [moment(),moment()],
                    '<?php echo e(__tr("Yesterday")); ?>': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    '<?php echo e(__tr("Last 7 Days")); ?>': [moment().subtract(6, 'days'), moment()],
                    '<?php echo e(__tr("Last 30 Days")); ?>': [moment().subtract(29, 'days'), moment()],
                    '<?php echo e(__tr("This Month")); ?>': [moment().startOf('month'), moment().endOf('month')],
                    '<?php echo e(__tr("Last Month")); ?>': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                opens: 'right',
            }, function(start, end, label) {
               start.format('YYYY-MM-DD') + ',' + end.format('YYYY-MM-DD');
            });
        });
    }
})(jQuery);<?php /**PATH /home/u248210191/domains/shivamenterprisesse.in/public_html/oldwaba/resources/views/server-compiled-js.blade.php ENDPATH**/ ?>