<?php
    $embeddedSignupDoneAt = getVendorSettings('embedded_setup_done_at');
    $isOnboardedViaEmbeddedSignup = (isWhatsAppBusinessAccountReady() and $embeddedSignupDoneAt);
    $isWhatsAppBusinessMobileAppOnboarded = getVendorSettings('whatsapp_onboarding_raw_data', 'is_app_onboarded');
    $phoneQualityRatings = [
        'GREEN' => __tr('Green - High quality'),
        'YELLOW' => __tr('Yellow - Medium quality'),
        'RED' => __tr('Red - Low quality'),
    ];
?>
<script>
    var phoneNumbersQualityRatings = <?php echo json_encode($phoneQualityRatings, 15, 512) ?>;
</script>
<div class="row">
    <div class="col-md-8"
        x-data="{ enableStep2: <?php echo e(getVendorSettings('facebook_app_id') ? 1 : 0); ?>, enableStep3: <?php echo e(getVendorSettings('whatsapp_access_token') ? 1 : 0); ?> }"
        x-cloak>
        <!-- Page Heading -->
        <h1>
            <?= __tr('WhatsApp Cloud API Setup') ?>
        </h1>
        <div class="accordion" id="whatsAppSetupSettingsBlock" x-data="{isSetupInProcess:false,newWhatsAppBusinessAccountId:null}" x-cloak>
            <template x-if="isSetupInProcess">
                <div class="text-center">
                    <div class="lw-loading-block col-12 text-center p-6" x-data="{lwProgressText:''}">
                        <img src="<?php echo e(asset('imgs/processing.svg')); ?>" alt="<?php echo e(__tr('Connecting WhatsApp API ...')); ?>">
                        <h2 class="text-danger mt-4 mb-2"><?php echo e(__tr('Please wait while we connecting you to the WhatsApp Cloud API, Do not refresh or redirect.')); ?></h2>
                        <pre class="p-2" x-cloak x-text="lwProgressText"></pre>
                    </div>
                </div>
            </template>
            <section x-show="!isSetupInProcess">
                <?php if($isOnboardedViaEmbeddedSignup): ?>
                <fieldset class="my-4 py-4">
                    <?php if($isWhatsAppBusinessMobileAppOnboarded): ?>
                        <div class="text-success"><strong><?php echo e(__tr('WhatsApp Business App - Cloud API connected using Embedded SignUp on __connectedAt__', [
                            '__connectedAt__' => formatDateTime($embeddedSignupDoneAt)
                            ])); ?></strong></div>
                            <?php else: ?>
                        <div class="text-success"><strong><?php echo e(__tr('WhatsApp API connected using Embedded SignUp on __connectedAt__', [
                            '__connectedAt__' => formatDateTime($embeddedSignupDoneAt)
                            ])); ?></strong></div>
                            </fieldset>
                             <?php endif; ?>
                        <?php endif; ?>
                <?php if(getAppSettings('enable_embedded_signup') and !$embeddedSignupDoneAt and !getVendorSettings('facebook_app_id')): ?>
                <fieldset x-show="!isSetupInProcess">
                    <legend><?php echo e(__tr('WhatsApp Setup with Facebook')); ?></legend>
                    <div class="text-center">
                        <?php if(!isWhatsAppBusinessAccountReady()): ?>
                        <button type="button"
                            style="background-color: #1877f2; border: 0; border-radius: 4px; color: #fff; cursor: pointer; font-family: Helvetica, Arial, sans-serif; "
                            class="btn btn-lg mb-4" onclick="launchWhatsAppSignup()">
                            <i class="fab fa-facebook"></i><span class="h2 text-white">
                                <?php echo e(__tr('Connect WhatsApp with Facebook')); ?>

                                <i class="fa fa-sign-in-alt"></i></span>
                        </button>
                        <?php endif; ?>
                    </div>
                </fieldset>
                <?php endif; ?>
                <?php if(getAppSettings('enable_embedded_signup') and getAppSettings('enable_whatsapp_manual_signup') and !$embeddedSignupDoneAt and !getVendorSettings('facebook_app_id')): ?>
                <h3 class="text-center mt-5"><?php echo e(__tr('OR')); ?></h3>
                <?php endif; ?>
                <?php if(getAppSettings('enable_whatsapp_manual_signup') and !$embeddedSignupDoneAt): ?>
                <fieldset>
                    <legend><?php echo e(__tr('Connect WhatsApp Manually')); ?></legend>
                    <fieldset class="lw-fieldset mb-3" <?php
                        $isFacebookAppRequirement=$embeddedSignupDoneAt ?
                        getVendorSettings('facebook_app_id') : (getVendorSettings('facebook_app_id')); ?>
                        x-data="{openForUpdate:false,fbAppIdExists:<?php echo e($isFacebookAppRequirement  ? 1 : 0); ?>,isWebhookVerified: <?php echo e(getVendorSettings('webhook_verified_at') ? 1 : 0); ?>,isWebhookMessagesFieldVerified: <?php echo e(getVendorSettings('webhook_messages_field_verified_at') ? 1 : 0); ?>}">
                        <legend data-toggle="collapse" data-target="#lwFacebookAppSettings" aria-expanded="true"
                            aria-controls="lwFacebookAppSettings"><?php echo __tr('Facebook Developer Account & Facebook App'); ?> <small class="text-muted"><?php echo e(__tr('Click to expand/collapse')); ?></small>
                        </legend>
                        <div class="collapse <?php echo e($isFacebookAppRequirement ? '' : 'show'); ?>" id="lwFacebookAppSettings" data-parent="#whatsAppSetupSettingsBlock">
                            <!-- whatsapp cloud api setup form -->
                            <form id="lwWhatsAppFacebookAppForm" class="lw-ajax-form lw-form"
                                name="whatsapp_setup_facebook_app_form" method="post"
                                action="<?= route('vendor.settings.write.update') ?>">
                                <input type="hidden" name="pageType" value="whatsapp_cloud_api_setup">
                                <!-- set hidden input field with form type -->
                                <input type="hidden" name="form_type" value="whatsapp_setup_facebook_app_form" />
                                <a href="https://developers.facebook.com/docs/whatsapp/cloud-api/get-started#set-up-developer-assets"
                                    target="_blank" class="float-right"><?php echo __tr('Help & More Information'); ?> <i class="fas fa-external-link-alt"></i></a>
                                <p>
                                    <?php echo __tr('To get started you should have __facebookApp__, you mostly need to select  Business as type of your app.', [
                                    '__facebookApp__' => '<strong>' . __tr('Facebook App') . '</strong>',
                                    ],
                                    ); ?>

                                <div>
                                    <a target="_blank" href="https://developers.facebook.com/apps/"
                                        class="btn btn-dark"><?php echo e(__tr('Create or Select Facebook App')); ?>

                                        <i class="fas fa-external-link-alt"></i></a>
                                </div>
                                </p>
                                <p>
                                    <?php echo __tr('Once you have the Facebook app, add your App ID below, you will find it in App Settings > Basic'); ?>

                                </p>
                                <div>
                                    <div x-show="!fbAppIdExists">
                                        <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'text','id' => 'lwFacebookAppId','dataFormGroupClass' => 'col-md-12 col-lg-4','label' => __tr('Facebook App ID'),'name' => 'facebook_app_id','placeholder' => ''.e(getVendorSettings('facebook_app_id') ? __tr('App ID exists, add new to update') : __tr('Your Facebook App ID')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'text','id' => 'lwFacebookAppId','data-form-group-class' => 'col-md-12 col-lg-4','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Facebook App ID')),'name' => 'facebook_app_id','placeholder' => ''.e(getVendorSettings('facebook_app_id') ? __tr('App ID exists, add new to update') : __tr('Your Facebook App ID')).'']); ?>
                                            <?php if(getVendorSettings('facebook_app_id')): ?>
                                                 <?php $__env->slot('prependText', null, []); ?> 
                                                    <i class="fa fa-check text-success"></i>
                                                 <?php $__env->endSlot(); ?>
                                            <?php else: ?>
                                             <?php $__env->slot('prependText', null, []); ?> 
                                                <i class="fa fa-times text-danger"></i>
                                             <?php $__env->endSlot(); ?>
                                            <?php endif; ?>
                                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                                        <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'text','id' => 'lwFacebookAppSecret','dataFormGroupClass' => 'col-md-12 col-lg-4','label' => __tr('Facebook App Secret'),'placeholder' => ''.e(getVendorSettings('facebook_app_secret') ? __tr('App Secret exists, add new to update') : __tr('Add your Facebook App Secret')).'','name' => 'facebook_app_secret']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'text','id' => 'lwFacebookAppSecret','data-form-group-class' => 'col-md-12 col-lg-4','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Facebook App Secret')),'placeholder' => ''.e(getVendorSettings('facebook_app_secret') ? __tr('App Secret exists, add new to update') : __tr('Add your Facebook App Secret')).'','name' => 'facebook_app_secret']); ?>
                                            <?php if(getVendorSettings('facebook_app_secret')): ?>
                                                 <?php $__env->slot('prependText', null, []); ?> 
                                                    <i class="fa fa-check text-success"></i>
                                                 <?php $__env->endSlot(); ?>
                                            <?php else: ?>
                                                 <?php $__env->slot('prependText', null, []); ?> 
                                                    <i class="fa fa-times text-danger"></i>
                                                 <?php $__env->endSlot(); ?>
                                            <?php endif; ?>
                                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                                        <div class="form-group mt-3 col">
                                            <!-- Update Button -->
                                            <button type="submit" class="btn btn-primary lw-btn-block-mobile">
                                                <?= __tr('Save') ?>
                                            </button>
                                            <!-- /Update Button -->
                                        </div>
                                        <div class="text-orange my-4"><?php echo e(__tr('Once you submit app id and app secret webhook will be created automatically')); ?></div>
                                    </div>
                                    <button x-show="fbAppIdExists"
                                        @click.prevent="fbAppIdExists = !fbAppIdExists,openForUpdate=true" type="button"
                                        class="btn btn-warning"><?php echo e(__tr('Click Here to Update')); ?></button>
                                </div>
                            </form>
                            <!-- / whatsapp cloud api setup form -->
                        </div>
                        <div class="badge badge-success py-1 mt-2" x-show="fbAppIdExists"><i class="fa fa-2x fa-check-square"></i>
                            <span class="lw-configured-badge"><?php echo e(__tr('Configured')); ?></span>
                        </div>
                        <div class="badge badge-danger py-1 mt-2" x-show="!fbAppIdExists && !openForUpdate">
                            <i class="fas fa-exclamation-circle fa-2x"></i> <span class="lw-configured-badge"><?php echo e(__tr('Not Configured')); ?></span>
                        </div>
                        <div x-show="isWebhookVerified">
                        <div class="badge badge-success py-1 mt-2">
                            <i class="fa fa-2x fa-check-square"></i> <span class="lw-configured-badge"><?php echo e(__tr('Webhook Configured')); ?></span>
                        </div>
                        <?php if(!$embeddedSignupDoneAt): ?>
                        <a x-show="fbAppIdExists" href="<?php echo e(route('vendor.webhook.disconnect.write')); ?>" data-method="post" class="btn btn-danger btn-sm lw-ajax-link-action"><?php echo e(__tr('Disconnect Webhook')); ?></a>
                        <?php endif; ?>
                    </div>
                        <div x-show="!isWebhookVerified">
                            <div class="badge badge-danger py-1 mt-2" >
                                <i class="fas fa-exclamation-circle fa-2x"></i> <span class="lw-configured-badge"><?php echo e(__tr('Webhook Not Configured')); ?></span>
                            </div>
                            <?php if(!$embeddedSignupDoneAt): ?>
                            <a x-show="fbAppIdExists" href="<?php echo e(route('vendor.webhook.connect.write')); ?>" data-method="post" class="btn btn-success btn-sm lw-ajax-link-action"><?php echo e(__tr('Connect Webhook')); ?></a>
                            <?php endif; ?>
                        </div>
                    </fieldset>
                    <fieldset class="lw-fieldset my-4"
                        x-data="{openForUpdate:false,whatsAppSettings:<?php echo e((getVendorSettings('whatsapp_access_token') and !getVendorSettings('whatsapp_access_token_expired')) ? 1 : 0); ?>,lwWhatsAppHelpBlockOpened:false}">
                        <legend data-toggle="collapse" data-target="#lwWhatsAppSettingsBlock" aria-expanded="false"
                            aria-controls="lwWhatsAppSettingsBlock"><?php echo __tr('WhatsApp Integration Setup'); ?> <small
                                class="text-muted"><?php echo e(__tr('Click to expand/collapse')); ?></small></legend>
                        <div class="collapse" :class="(!enableStep2) ? 'lw-disabled-block-content' : ''"
                            id="lwWhatsAppSettingsBlock" data-parent="#whatsAppSetupSettingsBlock">
                            <div class="border-danger rounded">
                                <?php echo e(__tr('You should have whatsapp_business_management and whatsapp_business_messaging permission')); ?>

                            </div>
                            <div class="col-12 mb-4">
                                <button class="btn btn-dark btn-sm" type="button" @click="lwWhatsAppHelpBlockOpened = !lwWhatsAppHelpBlockOpened"><?php echo e(__tr('Quick Help')); ?></button>
                            </div>
                            <div x-show="lwWhatsAppHelpBlockOpened" >
                                <p><?php echo e(__tr('Once you created your app you now need to choose WhatsApp from list click on the setup as shown in the below screenshot')); ?>

                                    <div class="col-12 col-md-3 col-xl-2">
                                        <img class="img-fluid" src="https://i.imgur.com/aeDwghR.png"
                                            alt="<?php echo e(__tr('WhatsApp Integration')); ?>">
                                    </div>
                                    </p>
                                    <p>
                                        <?php echo e(__tr('You may need to select or setup Meta Business Account, once done go to API setup from sidebar under the WhatsApp menu item as shown in the below screenshot')); ?>

                                    <div class="col-12 col-md-3 col-xl-2">
                                        <img class="img-fluid" src="https://i.imgur.com/G4fMiT9.png"
                                            alt="<?php echo e(__tr('WhatsApp API Setup')); ?>">
                                    </div>
                                    </p>
                            </div>
                            <div>
                                <!-- whatsapp cloud api setup form -->
                                <form x-show="!whatsAppSettings" id="lwWhatsAppSetupBusinessForm"
                                    class="lw-ajax-form lw-form" name="whatsapp_setup_business_form" method="post"
                                    action="<?= route('vendor.settings.write.update') ?>">
                                    <input type="hidden" name="pageType" value="whatsapp_cloud_api_setup">
                                    <!-- set hidden input field with form type -->
                                    <input type="hidden" name="form_type" value="whatsapp_setup_business_form" />
                                    <div x-data="{newAccessToken:''}">
                                        <div class="float-right">
                                            <a target="_blank"
                                                href="https://developers.facebook.com/docs/whatsapp/business-management-api/get-started#1--acquire-an-access-token-using-a-system-user-or-facebook-login"
                                                class=""><?php echo __tr('Help & More Information'); ?> <i
                                                    class="fas fa-external-link-alt"></i></a> | <a target="_blank"
                                                href="https://www.cloudperitus.com/blog/whatsapp-cloud-api-integration-generating-permanent-access-token"
                                                class=""><?php echo __tr('External Help'); ?> <i
                                                    class="fas fa-external-link-alt"></i></a>
                                        </div>
                                        
                                        <?php if(getVendorSettings('whatsapp_access_token_expired')): ?>
                                        <div class="alert alert-white border-danger text-danger my-3">
                                            <?php echo e(__tr('Your token seems to be expired, Generate new token, prefer creating
                                            permanent token')); ?>

                                        </div>
                                        <?php endif; ?>
                                        <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['placeholder' => ''.e(getVendorSettings('whatsapp_access_token') ? __tr('Token exists, add new to update') : __tr('Your Access Token')).'','type' => 'text','id' => 'lwAccessToken','dataFormGroupClass' => 'col-md-12 col-lg-8','label' => __tr('Access Token'),'name' => 'whatsapp_access_token','xModel' => 'newAccessToken','helpText' => __tr(
                            'You can either use Temporary access token or Permanent Access token, as the Temporary token expires in 24 hours its strongly recommended that you should create Permanent token.',
                        )]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => ''.e(getVendorSettings('whatsapp_access_token') ? __tr('Token exists, add new to update') : __tr('Your Access Token')).'','type' => 'text','id' => 'lwAccessToken','data-form-group-class' => 'col-md-12 col-lg-8','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Access Token')),'name' => 'whatsapp_access_token','x-model' => 'newAccessToken','helpText' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr(
                            'You can either use Temporary access token or Permanent Access token, as the Temporary token expires in 24 hours its strongly recommended that you should create Permanent token.',
                        ))]); ?>
                                            <?php if(getVendorSettings('whatsapp_access_token') and !getVendorSettings('whatsapp_access_token_expired')): ?>
                                                 <?php $__env->slot('prependText', null, []); ?> 
                                                    <i class="fa fa-check text-success"></i>
                                                 <?php $__env->endSlot(); ?>
                                            <?php else: ?>
                                                 <?php $__env->slot('prependText', null, []); ?> 
                                                    <i class="fa fa-times text-danger"></i>
                                                 <?php $__env->endSlot(); ?>
                                            <?php endif; ?>
                                             <?php $__env->slot('append', null, []); ?> 
                                                <a target="_blank" x-bind:href="'https://developers.facebook.com/tools/debug/accesstoken/?access_token='+newAccessToken" x-bind:class="!newAccessToken ? 'disabled' : ''" class="btn btn-light"><?php echo e(__tr('Debug Token')); ?> <i class="fas fa-external-link-alt"></i></a>
                                             <?php $__env->endSlot(); ?>
                                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                                        
                                    </div>
                                    <div class="col-md-12 col-lg-4">
                                        
                                        <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['placeholder' => ''.e(getVendorSettings('whatsapp_business_account_id') ? __tr('ID exists, add new to update') : __tr('Your Business Account ID')).'','type' => 'text','id' => 'lwBusinessAccountId','dataFormGroupClass' => '','label' => __tr('WhatsApp Business Account ID'),'name' => 'whatsapp_business_account_id','xModel' => 'newWhatsAppBusinessAccountId']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => ''.e(getVendorSettings('whatsapp_business_account_id') ? __tr('ID exists, add new to update') : __tr('Your Business Account ID')).'','type' => 'text','id' => 'lwBusinessAccountId','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('WhatsApp Business Account ID')),'name' => 'whatsapp_business_account_id','x-model' => 'newWhatsAppBusinessAccountId']); ?>
                                            <?php if(getVendorSettings('whatsapp_business_account_id')): ?>
                                                 <?php $__env->slot('prependText', null, []); ?> 
                                                    <i class="fa fa-check text-success"></i>
                                                 <?php $__env->endSlot(); ?>
                                            <?php else: ?>
                                                 <?php $__env->slot('prependText', null, []); ?> 
                                                    <i class="fa fa-times text-danger"></i>
                                                 <?php $__env->endSlot(); ?>
                                            <?php endif; ?>
                                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                                        
                                    </div>
                                    <div class="form-group mt-3 col">
                                        <!-- Update Button -->
                                        <button type="submit" class="btn btn-primary lw-btn-block-mobile">
                                            <?= __tr('Save') ?>
                                        </button>
                                        <!-- /Update Button -->
                                    </div>
                                </form>
                                <button x-show="whatsAppSettings" @click.prevent="whatsAppSettings = !whatsAppSettings, openForUpdate = true" type="button" class="btn btn-warning"><?php echo e(__tr('Click here to Update')); ?></button>
                            </div>
                        </div>
                        <div class="badge badge-success py-1 mt-2" x-show="whatsAppSettings"><i
                                class="fa fa-2x fa-check-square"></i> <span class="lw-configured-badge"><?php echo e(__tr('Configured')); ?></span></div>
                        <div class="badge badge-danger py-1 mt-2" x-show="!whatsAppSettings && !openForUpdate"><i
                                class="fas fa-exclamation-circle fa-2x"></i> <span class="lw-configured-badge"><?php echo e(__tr('Not Configured')); ?></span></div>
                    </fieldset>
                </fieldset>
                <?php if(getVendorSettings('whatsapp_token_info_data')): ?>
                <fieldset>
                    <legend><?php echo e(__tr('Access Token Information')); ?></legend>
                    <?php if(isDemo() and isDemoVendorAccount()): ?>
                        <div class="alert alert-dark">
                            <?php echo e(__tr('Information Hidden for Demo Account')); ?>

                        </div>
                    <?php else: ?>
                    <dl>
                        <dt><?php echo e(__tr('Permission scopes')); ?></dt>
                        <dd><?php echo e(implode(', ', getVendorSettings('whatsapp_token_info_data', 'scopes'))); ?></dd>
                        <dt><?php echo e(__tr('Issued at')); ?></dt>
                        <dd><?php echo e(getVendorSettings('whatsapp_token_info_data', 'issued_at') ? formatDateTime(getVendorSettings('whatsapp_token_info_data', 'issued_at')) : __tr('N/A')); ?></dd>
                        <dt><?php echo e(__tr('Expiry at')); ?></dt>
                        <?php if(getVendorSettings('whatsapp_token_info_data', 'expires_at')): ?>
                            <dd><?php echo e(formatDateTime(getVendorSettings('whatsapp_token_info_data', 'expires_at'))); ?> <small class="text-muted">(<?php echo e(formatDiffForHumans(getVendorSettings('whatsapp_token_info_data', 'expires_at'), 5)); ?>)</small>
                                <?php if(\Carbon\Carbon::parse(getVendorSettings('whatsapp_token_info_data', 'expires_at')) < now()): ?>
                                <small class="text-danger"> - <?php echo e(__tr('Expired')); ?></small>
                                <?php endif; ?></dd>
                        <?php else: ?>
                        <dd><?php echo e(__tr('N/A')); ?></dd>
                        <?php endif; ?>
                        <dd>
                            <hr>
                            <a target="_blank" href="https://developers.facebook.com/tools/debug/accesstoken/?access_token=<?php echo e(getVendorSettings('whatsapp_access_token')); ?>" class="btn btn-light btn-sm"><?php echo e(__tr('Debug Token')); ?> <i class="fas fa-external-link-alt"></i></a>
                        </dd>
                    </dl>
                    <?php endif; ?>
                </fieldset>
                <?php endif; ?>
                <?php endif; ?>
                    <?php if(getVendorSettings('whatsapp_business_account_id')): ?>
                    <fieldset>
                        <legend><?php echo e(__tr('Default Phone Number')); ?></legend>
                        <div :class="(newWhatsAppBusinessAccountId) ? 'lw-disabled-block-content' : ''" class="col-md-12 col-lg-4">
                            <form id="lwWhatsAppSetupBusinessForm"
                                    class="lw-ajax-form lw-form" name="whatsapp_setup_business_form" method="post"
                                    action="<?= route('vendor.settings.write.update') ?>">
                                    <input type="hidden" name="pageType" value="whatsapp_cloud_api_setup">
                                    <input type="hidden" name="whatsapp_access_token" value="">
                            
                            <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'selectize','dataFormGroupClass' => '','name' => 'current_phone_number_id','label' => __tr('Select Default Phone Number'),'dataSelected' => ''.e(getVendorSettings('current_phone_number_id')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'selectize','data-form-group-class' => '','name' => 'current_phone_number_id','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Select Default Phone Number')),'data-selected' => ''.e(getVendorSettings('current_phone_number_id')).'']); ?>
                             <?php $__env->slot('selectOptions', null, []); ?> 
                                <?php if(!empty(getVendorSettings('whatsapp_phone_numbers'))): ?>
                                <?php $__currentLoopData = getVendorSettings('whatsapp_phone_numbers'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $whatsappPhoneNumber): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($whatsappPhoneNumber['id']); ?>"><?php echo e($whatsappPhoneNumber['display_phone_number']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php elseif(getVendorSettings('current_phone_number_id')): ?>
                                <option value="<?php echo e(getVendorSettings('current_phone_number_id')); ?>"><?php echo e(getVendorSettings('current_phone_number_number')); ?></option>
                                <?php endif; ?>
                             <?php $__env->endSlot(); ?>
                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                            
                            <div class="form-group mt-3">
                                <!-- Update Button -->
                                <button type="submit" class="btn btn-primary lw-btn-block-mobile">
                                    <?= __tr('Save') ?>
                                </button>
                                <!-- /Update Button -->
                            </div>
                            </form>
                        </div>
                    </fieldset>
                    <?php endif; ?>
                <fieldset class="lw-fieldset mb-3"
                    x-data="{openForUpdate:false,testContactExists: <?php echo e(getVendorSettings('test_recipient_contact') ? 1 : 0); ?>}">
                    <legend data-toggle="collapse" data-target="#lwWhatsAppTestContactBlock" aria-expanded="false"
                        aria-controls="lwWhatsAppTestContactBlock"><?php echo __tr('Test Contact for Campaign'); ?> <small
                            class="text-muted"><?php echo e(__tr('Click to expand/collapse')); ?></small></legend>
                    <div class="collapse" :class="(!enableStep3) ? 'lw-disabled-block-content' : ''"
                        id="lwWhatsAppTestContactBlock" data-parent="#whatsAppSetupSettingsBlock">
                        <!-- whatsapp cloud api setup form -->
                        <form id="lwWhatsAppTestContact" class="lw-ajax-form lw-form" name="whatsapp_setup_test_contact"
                            method="post" action="<?= route('vendor.settings.write.update') ?>">
                            <input type="hidden" name="pageType" value="whatsapp_cloud_api_setup">
                            <!-- set hidden input field with form type -->
                            <input type="hidden" name="form_type" value="whatsapp_setup_test_contact" />
                            <div class="row">
                                <div class="col-md-12 col-lg-6">
                                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'number','dataFormGroupClass' => '','name' => 'test_recipient_contact','label' => __tr('Test Contact Number'),'value' => ''.e($configurationData['testContact']).'','helpText' => __tr('WhatsApp number to test, It should be with country code without 0 or +')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'number','data-form-group-class' => '','name' => 'test_recipient_contact','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Test Contact Number')),'value' => ''.e($configurationData['testContact']).'','helpText' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('WhatsApp number to test, It should be with country code without 0 or +'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                                </div>
                            </div>
                            <div class="form-group mt-3 col p-0">
                                <!-- Update Button -->
                                <button type="submit" class="btn btn-primary lw-btn-block-mobile">
                                    <?= __tr('Save') ?>
                                </button>
                                <!-- /Update Button -->
                            </div>
                        </form>
                    </div>
                    <div class="badge badge-success py-1 mt-2" x-show="testContactExists"><i
                            class="fa fa-2x fa-check-square"></i> <span class="lw-configured-badge"><?php echo e(__tr('Configured')); ?></span></div>
                    <div class="badge badge-danger py-1 mt-2" x-show="!testContactExists"><i
                            class="fas fa-exclamation-circle fa-2x"></i> <span class="lw-configured-badge"><?php echo e(__tr('Not
                            Configured')); ?></span></div>
                </fieldset>
                <div class="alert mb-3" :class="(!enableStep3) ? 'lw-disabled-block-content' : ''">
                    <legend><?php echo __tr('It\'s ready'); ?></legend>
                    <div>
                        <?php echo e(__tr('In order to send template message you should have created and approved templates for WhatsApp Business.')); ?>

                        <div class="my-3">
                            <a class="lw-btn btn btn-light" href="<?php echo e(route('vendor.whatsapp_service.templates.read.list_view')); ?>">
                                <?php echo e(__tr('Manage Templates')); ?></a>
                            <a class="lw-btn btn btn-light" href="<?php echo e(route('vendor.contact.read.list_view')); ?>">
                                <?php echo e(__tr('Manage Contacts')); ?></a>
                        <a class="lw-btn btn btn-default" href="<?php echo e(route('vendor.campaign.new.view')); ?>"><?php echo e(__tr('Create New Campaign')); ?></a>
                        <a data-confirm="#lwDisconnectAccount-template" href="<?php echo e(route('vendor.account.disconnect.write')); ?>" data-method="post" class="btn btn-danger lw-ajax-link-action"><?php echo e(__tr('Disconnect Account')); ?></a>
                        <script type="text/template" id="lwDisconnectAccount-template">
                            <h2><?php echo e(__tr('Are You Sure!')); ?></h2>
                            <p><?php echo e(__tr('Do you want to disconnect WhatsApp, you won\'t be able to send and receive messages')); ?></p>
                    </script>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <div class="col-md-4">
        <fieldset x-data="initializedWhatsAppData">
            <legend><?php echo e(__tr('WhatsApp Business Info')); ?></legend>
            <?php if(isDemo() and isDemoVendorAccount()): ?>
            <div class="alert alert-dark">
                <?php echo e(__tr('Information Hidden for Demo Account')); ?>

            </div>
            <?php else: ?>
            <fieldset>
                <legend><?php echo e(__tr('Phone Numbers')); ?></legend>
                    <div class="card shadow-none border-0">
                        <template x-for="whatsAppPhoneNumber in whatsAppPhoneNumbers">
                        <div class="card-header">
                            <dl>
                                <dt><?php echo e(__tr('Phone Number ID')); ?></dt>
                                <dd x-text="whatsAppPhoneNumber.id"></dd>
                                <dt><?php echo e(__tr('Verified Name')); ?></dt>
                                <dd x-text="whatsAppPhoneNumber.verified_name"></dd>
                             
                                <dt><?php echo e(__tr('Display Phone Number')); ?></dt>
                                <dd x-text="whatsAppPhoneNumber.display_phone_number"></dd>
                                <dt><?php echo e(__tr('Quality Rating')); ?> <a class="btn btn-sm btn-link" href="https://www.facebook.com/business/help/896873687365001" target="_blank" rel="noopener noreferrer"><i class="fa fa-external-link-alt"></i></a></dt>
                                <dd x-bind:class="'text-' + whatsAppPhoneNumber.quality_rating.toLowerCase()" x-text="phoneNumbersQualityRatings[whatsAppPhoneNumber.quality_rating]"></dd>
                                <dt x-show="whatsAppPhoneNumber?.name_status"><?php echo e(__tr('Name Status')); ?></dt>
                                <dd x-show="whatsAppPhoneNumber?.name_status" x-text="whatsAppPhoneNumber?.name_status"></dd>
                                <dt x-show="whatsAppPhoneNumber?.new_name_status"><?php echo e(__tr('New Name Status')); ?></dt>
                                <dd x-show="whatsAppPhoneNumber?.new_name_status" x-text="whatsAppPhoneNumber?.new_name_status"></dd>
                                 <?php if(!$isWhatsAppBusinessMobileAppOnboarded): ?>
                                <dd>
                                    <a data-pre-callback="appFuncs.clearContainer" title="<?php echo e(__tr('Update Display Name')); ?>" class="lw-btn btn btn-sm btn-outline-default lw-ajax-link-action" data-response-template="#lwDisplayNameUpdateBody" x-bind:href="__Utils.apiURL('<?php echo e(route('vendor.whatsapp.display_name.read', [ 'phoneNUmberId'])); ?>', {'phoneNUmberId': whatsAppPhoneNumber.id})"  data-toggle="modal" data-target="#lwDisplayNameUpdate"><i class="fa fa-edit"></i> <?php echo e(__tr('Update Display Name')); ?></a>
                                    <a data-pre-callback="appFuncs.clearContainer" title="<?php echo e(__tr('Update Business Profile')); ?>" class="lw-btn btn btn-sm btn-outline-default lw-ajax-link-action" data-response-template="#lwBusinessProfileUpdateBody" x-bind:href="__Utils.apiURL('<?php echo e(route('vendor.whatsapp.business_profile.read', [ 'phoneNUmberId'])); ?>', {'phoneNUmberId': whatsAppPhoneNumber.id})"  data-toggle="modal" data-target="#lwBusinessProfileUpdate"><i class="fa fa-edit"></i> <?php echo e(__tr('Update Business Profile')); ?></a>
                                    <a data-pre-callback="appFuncs.clearContainer" data-response-template="#lwTwoSepVerificationCodeBody" x-bind:href="__Utils.apiURL('<?php echo e(route('vendor.whatsapp.business_profile.read', [ 'phoneNUmberId'])); ?>', {'phoneNUmberId': whatsAppPhoneNumber.id})"  title="<?php echo e(__tr('Two-Step Verification Code')); ?>" class="lw-btn btn btn-sm btn-outline-default lw-ajax-link-action" data-toggle="modal" data-target="#lwTwoSepVerificationCode"><i class="fa fa-edit"></i> <?php echo e(__tr('Update Two-Step Verification Code')); ?></a>
                                </dd>
                                <?php endif; ?>
                            </dl>
                        </div>
                    </template>
                    </div>
                    <div class="mt-4">
                        <a href="<?php echo e(route('vendor.whatsapp.sync_phone_numbers')); ?>" class="btn btn-primary btn-sm lw-ajax-link-action <?php echo e(!getVendorSettings('whatsapp_access_token') ? 'disabled' : ''); ?>"
            data-method="post"><?php echo e(__tr('Re-sync Phone Numbers')); ?></a>
            <?php if(!$isWhatsAppBusinessMobileAppOnboarded): ?>
            <a target="_blank" href="https://business.facebook.com/wa/manage/phone-numbers/?waba_id=<?php echo e(getVendorSettings('whatsapp_business_account_id')); ?>"
            class="btn btn-dark btn-sm <?php echo e(!getVendorSettings('whatsapp_access_token') ? 'disabled' : ''); ?>" data-method="post"><?php echo e(__tr('Manage Phone Numbers')); ?> <i class="fas fa-external-link-alt"></i></a>
            <a target="_blank" href="https://business.facebook.com/latest/whatsapp_manager/overview/?nav_ref=whatsapp_manager&asset_id=<?php echo e(getVendorSettings('whatsapp_business_account_id')); ?>"
            class="btn btn-dark btn-sm <?php echo e(!getVendorSettings('whatsapp_access_token') ? 'disabled' : ''); ?>" data-method="post"><?php echo e(__tr('WhatsApp Manager')); ?> <i class="fas fa-external-link-alt"></i></a>
            <?php endif; ?>
            <a target="_blank" href="https://business.facebook.com/billing_hub/accounts/details?asset_id=<?php echo e(getVendorSettings('whatsapp_business_account_id')); ?>&account_type=whatsapp-business-account"
            class="btn btn-dark btn-sm <?php echo e(!getVendorSettings('whatsapp_access_token') ? 'disabled' : ''); ?>" data-method="post"><?php echo e(__tr('Manage Payments')); ?> <i class="fas fa-external-link-alt"></i></a>
                    </div>
            </fieldset>
            <fieldset>
                <legend><?php echo e(__tr('Overall Health')); ?></legend>
            <dl>
                <dt><?php echo e(__tr('WhatsApp Business ID')); ?></dt>
                <dd x-text="healthStatusData?.whatsapp_business_account_id"></dd>
                <dt><?php echo e(__tr('Status as at')); ?></dt>
                <dd x-text="healthStatusData?.health_status_updated_at_formatted"></dd>
                <dt><?php echo e(__tr('Overall Health')); ?></dt>
                <dd x-text="healthStatusData?.health_data?.health_status.can_send_message"></dd>
            </fieldset>
                <template x-for="healthEntity in healthStatusData?.health_data?.health_status.entities">
                        <fieldset>
                            <legend> <span x-text="healthEntity.entity_type"></span><?php if($embeddedSignupDoneAt): ?> <template x-if="healthEntity.entity_type != 'APP'"> - <span
                                    x-text="healthEntity.id"></span> </template> <?php else: ?> - <span
                                    x-text="healthEntity.id"></span> <?php endif; ?> </legend>
                            <dl>
                                <dt><?php echo e(__tr('Can Send Message')); ?></dt>
                                <dd x-text="healthEntity.can_send_message"></dd>
                                <template x-if="healthEntity.additional_info ?? ''">
                                    <div class="alert alert-dark">
                                        <strong><?php echo e(__tr('Additional Info from Meta')); ?></strong>
                                        <p x-text="healthEntity.additional_info ?? ''"></p>
                                    </div>
                                </template>
                                <template x-for="errorItem in healthEntity.errors">
                                    <dl>
                                        <dt><?php echo e(__tr('Error Description')); ?></dt>
                                        <dd class="text-danger"
                                            x-text="' (' + errorItem.error_code + ') ' + errorItem.error_description">
                                        </dd>
                                        <dt><?php echo e(__tr('Possible Solution')); ?></dt>
                                        <dd class="text-success" x-text="errorItem.possible_solution"></dd>
                                    </dl>
                                </template>
                                <?php if(!$isOnboardedViaEmbeddedSignup): ?>
                                <template x-if="healthEntity.entity_type == 'BUSINESS'"> <div>
                                    <a target="_blank" :href="'https://business.facebook.com/latest/settings/security_center/?business_id=' + healthEntity.id"
                                    class="btn btn-success btn-sm <?php echo e(!getVendorSettings('whatsapp_access_token') ? 'disabled' : ''); ?>" data-method="post"><?php echo e(__tr('Business Verification')); ?> <i class="fas fa-external-link-alt"></i></a>
                                </div> </template>
                                <?php endif; ?>
                                <?php if(!$isOnboardedViaEmbeddedSignup): ?>
                                <template x-if="healthEntity.entity_type == 'APP'">
                                    <a target="_blank" :href="'https://developers.facebook.com/apps/'+healthEntity.id+'/whatsapp-business/wa-dev-console'"
                                    class="btn btn-dark btn-sm <?php echo e(!getVendorSettings('whatsapp_access_token') ? 'disabled' : ''); ?>" data-method="post"><?php echo e(__tr('Go to WhatsApp FB App')); ?> <i class="fas fa-external-link-alt"></i></a>
                                    </template>
                                <?php endif; ?>
                            </dl>
                        </fieldset>
                    </template>
            </dl>
            <a href="<?php echo e(route('vendor.whatsapp.health.status')); ?>"
                class="btn btn-primary mt-4 btn-sm lw-ajax-link-action <?php echo e(!getVendorSettings('whatsapp_access_token') ? 'disabled' : ''); ?>"
                data-method="post"><?php echo e(__tr('Refresh Status')); ?></a>
            <?php endif; ?>
        </fieldset>
    </div>
</div>
<script>
    (function() {
       'use strict';
       <?php if(getVendorSettings('whatsapp_business_account_id')): ?>
        document.addEventListener('alpine:init', () => {
            Alpine.data('initializedWhatsAppData', () => ({
                healthStatusData: <?php if(getVendorSettings('whatsapp_health_status_data')): ?><?php echo json_encode(getVendorSettings('whatsapp_health_status_data'), 15, 512) ?>[<?php echo e(getVendorSettings('whatsapp_business_account_id')); ?>]<?php else: ?>{}<?php endif; ?>,
                whatsAppPhoneNumbers: <?php echo json_encode(getVendorSettings('whatsapp_phone_numbers'), 15, 512) ?>
            }));
       <?php else: ?>
       document.addEventListener('alpine:init', () => {
        Alpine.data('initializedWhatsAppData', () => ({
            healthStatusData: {},
            whatsAppPhoneNumbers: [],
        }));
       <?php endif; ?>
   });
})();
</script>
<?php if(getAppSettings('enable_embedded_signup')): ?>
<script>
    (function() {
       'use strict';
  window.fbAsyncInit = function() {
    FB.init({
      appId            : '<?php echo e(getAppSettings('embedded_signup_app_id')); ?>',
      autoLogAppEvents : true,
      xfbml:    true, // parse social plugins on this page
      version          : 'v23.0'
    });
  };
  })();
</script>
<script async defer crossorigin="anonymous" src="https://connect.facebook.net/en_US/sdk.js">
</script>
<script>
    (function() {
       'use strict';
  // Facebook Login with JavaScript SDK
   window.launchWhatsAppSignup = function() {
    __DataRequest.updateModels({isSetupInProcess:true});
    // Conversion tracking code
    // fbq && fbq('trackCustom', 'WhatsAppOnboardingStart', {appId: 'your-facebook-app-id', feature: 'whatsapp_embedded_signup'});
    var tempAccessCode = '',
        phoneNumberId = '',
        waBaId = '',
        isAppOnboarding = false;
    // Launch Facebook login
    FB.login(function (response) {
      if (response.authResponse) {
        //Use this token to call the debug_token API and get the shared WABA's ID
        // const accessToken = response.authResponse.accessToken;
        tempAccessCode = response.authResponse.code;
        if(tempAccessCode) {
            __DataRequest.post('<?php echo e(route('vendor.whatsapp_setup.embedded_signup.write')); ?>', {
                'request_code' : tempAccessCode,
                'waba_id' : waBaId,
                'phone_number_id' : phoneNumberId,
                'is_app_onboarding' : isAppOnboarding
            }, function() {
                __DataRequest.updateModels({isSetupInProcess:false});
            }, {
                eventStreamUpdate: true
            });
        } else {
            __DataRequest.updateModels({isSetupInProcess:false});
        }
      } else {
        alert('User cancelled login or did not fully authorize.');
        __DataRequest.updateModels({isSetupInProcess:false});
      }
    }, {
      config_id: '<?php echo e(getAppSettings('embedded_signup_config_id')); ?>', // configuration ID obtained in the previous step goes here
      response_type: 'code',     // must be set to 'code' for System User access token
      override_default_response_type: true,
      extras: {
        setup: {
        //   ... // Prefilled data can go here
        },
        featureType: '<?php echo e(getAppSettings('enable_business_app_onboarding') ? 'whatsapp_business_app_onboarding' : ''); ?>',
        sessionInfoVersion: '3'
      }
    });
    const sessionInfoListener = (event) => {
        // console.log(event);
  if (event.origin !== "https://www.facebook.com") return;
  try {
    const data = JSON.parse(event.data);
    // console.log(data);
    if (data.type === 'WA_EMBEDDED_SIGNUP') {
      // if user finishes the Embedded Signup flow
      if ((data.event === 'FINISH') || (data.event === 'FINISH_WHATSAPP_BUSINESS_APP_ONBOARDING')) {
        const {phone_number_id, waba_id} = data.data;
        phoneNumberId = phone_number_id;
        waBaId = waba_id;
        <?php if(getAppSettings('enable_business_app_onboarding')): ?>
        if(data.event === 'FINISH_WHATSAPP_BUSINESS_APP_ONBOARDING') {
            isAppOnboarding = 'YES';
        }
        <?php endif; ?>
      }
      // if user cancels the Embedded Signup flow
      else {
       const{current_step} = data.data;
      }
    }
  } catch {
    // Don’t parse info that’s not a JSON
    // console.log('Non JSON Response', event.data);
  }
};

window.addEventListener('message', sessionInfoListener);
  }
  })();
</script>
<?php endif; ?><?php /**PATH /home/imqsvuod/wala.guru/wbiz/resources/views/vendors/settings/whatsapp-cloud-api-setup.blade.php ENDPATH**/ ?>