<?php
$vendorIdOrUid = $vendorIdOrUid ?? getVendorUid();
if(!isset($vendorViewBySuperAdmin)) {
    $vendorViewBySuperAdmin = null;
}
?>
<?php $__env->startSection('content'); ?>
<?php if(hasCentralAccess()): ?>
<?php echo $__env->make('users.partials.header', [
'title' => __tr('__vendorTitle__ Details', [
    '__vendorTitle__' => $vendorInfo['title'] ?? getVendorSettings('title')
]),
'description' => '',
// 'class' => 'col-lg-7'
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php else: ?>
<?php echo $__env->make('users.partials.header', [
'title' => __tr('Hi __userFullName__,', [
    '__userFullName__' => getUserAuthInfo('profile.first_name')
]),
'description' => '',
// 'class' => 'col-lg-7'
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php endif; ?>
<?php $isExtendedLicence = (getAppSettings('product_registration', 'licence') === 'dee257a8c3a2656b7d7fbe9a91dd8c7c41d90dc9'); ?>
<div class="container-fluid">
    <?php if(hasCentralAccess()): ?>
    <div class="col-xl-12 p-0">
        <!-- breadcrumbs -->
        <nav aria-label="breadcrumb" class="lw-breadcrumb-container">
            <ol class="breadcrumb bg-transparent text-light p-0 m-0">
                <li class=" breadcrumb-item mb-3">
                    <a class="text-decoration-none" href="<?php echo e(route('central.vendors')); ?>"><?php echo e(__tr('Manage Vendors')); ?></a>

                </li>
                <li class="text-light breadcrumb-item" aria-current="page"><?php echo e(__tr('Details')); ?></li>
            </ol>
        </nav>
        <!-- /breadcrumbs -->
    </div>
    <?php endif; ?>
</div>

<?php if(hasVendorAccess() or $vendorViewBySuperAdmin ): ?>
<?php
$planDetails = vendorPlanDetails(null, null, $vendorInfo['id']);
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12 mb-5">
            <fieldset>
                <legend><?php echo e(__tr('Basic Information')); ?></legend>
                <dl>
                    <dt><?php echo e(__tr('Vendor Name')); ?></dt>
                    <dd><?php echo e($vendorInfo['title']); ?></dd>
                </dl>
            </fieldset>
            <fieldset class="mb-4">
                
                <legend><?php echo e(__tr('Current Subscribed Plan')); ?></legend>
                <?php if($planDetails->hasActivePlan()): ?>
                <h2 class="text-primary"><?php echo e($planDetails->planTitle()); ?></h2>
                <?php
                $planStructure = $planDetails->plan_id ? getPaidPlans($planDetails->plan_id) : getFreePlan();
                $planCharges = $planStructure['charges'][$planDetails->frequency] ?? null;
                ?>
                <?php if (!__isEmpty(data_get($planStructure, 'features'))) { ?>
                <?php $__currentLoopData = $planStructure['features']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featureKey => $featureValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                         $structureFeatureValue = $featureValue;
                        $featureValue = $featureValue;
                    ?>
                    <div class="my-2">
                     <?php if(isset($featureValue['type']) and ($featureValue['type'] == 'switch')): ?>
                         <?php if(isset($featureValue['limit']) and $featureValue['limit']): ?>
                         <i class="fa fa-check mr-2 text-success"></i>
                         <?php else: ?>
                         <i class="fa fa-times mr-2 text-danger"></i>
                         <?php endif; ?>
                         <?php echo e(($structureFeatureValue['description'])); ?>

                         <?php else: ?>
                        <i class="fa fa-check text-success mr-2"></i>
                        <?php if(isset($featureValue['limit']) and $featureValue['limit'] < 0): ?>
                            <?php echo e(__tr('Unlimited')); ?>

                        <?php elseif(isset($featureValue['limit'])): ?>
                            <?php echo e($featureValue['limit']); ?>

                        <?php endif; ?>
                        <?php echo e(($structureFeatureValue['description'])); ?>

                        <?php if(isset($featureValue['limit_duration_title'])): ?>
                             <?php echo e(($featureValue['limit_duration_title'])); ?>

                         <?php endif; ?>
                         <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php } ?>
                <hr>
                <?php if($planCharges): ?>
                <h2 class="text-blue">
                    <?php echo e($planCharges['title'] ?? ''); ?> <?php echo e(formatAmount($planCharges['charge'], true)); ?>

                </h2>
                <hr>
                <?php endif; ?>
                <?php else: ?>
                <div class="alert alert-warning"><?php echo e(__tr('Vendor does not have any active plan.')); ?></div>
                <?php endif; ?>
                <?php if($planDetails->isAuto()): ?>
              <h4 class="text-warning">
                <?php echo e(__tr('Please note vendor is on the Auto Renewal Subscription Plan, First you need to cancel it to manage manual subscription.')); ?>

              </h4>
              <a data-show-processing="true" class="lw-ajax-link-action btn btn-danger" data-method="post" href="<?php echo e(route('central.subscription.write.cancel', [
                'vendorUid' => $vendorIdOrUid
              ])); ?>">
                <?php echo e(__tr('Cancel Auto Subscription and Discard Grace Period if any')); ?>

            </a>
             <?php else: ?>
             <?php if($isExtendedLicence): ?>
                <button type="button" class="lw-btn btn btn-primary" data-toggle="modal" data-target="#lwAddNewManualSubscription"> <?php echo e(__tr('Create New Subscription')); ?></button>
                <?php else: ?>
                <div class="alert alert-danger">
                    <?php echo e(__tr('Extended licence required to enable manage subscription')); ?>

                </div>
                <?php endif; ?>
                <?php endif; ?>
            </fieldset>
                    <!-- New Subscription Modal -->
        <?php if (isset($component)) { $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.modal','data' => ['id' => 'lwAddNewManualSubscription','header' => __tr('Create New Subscription'),'hasForm' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwAddNewManualSubscription','header' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Create New Subscription')),'hasForm' => true]); ?>
            <!--  New Subscription Form -->
            <?php if (isset($component)) { $__componentOriginald0b55ee435ec3aeeadffee8b0df479da = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.form','data' => ['xData' => '{calculated_ends_at:null}','id' => 'lwAddNewManualSubscriptionForm','action' => route('central.subscription.manual_subscription.write.create'),'dataCallbackParams' => ['modalId' => '#lwAddNewManualSubscription', 'datatableId' => '#lwManualSubscriptionList'],'dataCallback' => 'appFuncs.modelSuccessCallback']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['x-data' => '{calculated_ends_at:null}','id' => 'lwAddNewManualSubscriptionForm','action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('central.subscription.manual_subscription.write.create')),'data-callback-params' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['modalId' => '#lwAddNewManualSubscription', 'datatableId' => '#lwManualSubscriptionList']),'data-callback' => 'appFuncs.modelSuccessCallback']); ?>
                <!-- form body -->
                <div class="lw-form-modal-body">
                    <?php if($isExtendedLicence): ?>
                    <div class="alert alert-danger">
                        <?php echo e(__tr('It will cancelled all the existing active subscriptions and create new subscription')); ?>

                    </div>
                    <!-- form fields form fields -->
                    <input type="hidden" name="vendor_uid" value="<?php echo e($vendorInfo['uid']); ?>">
                    <!-- Plan_Id -->
                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'selectize','dataLwPlugin' => 'lwSelectize','id' => 'lwPlanIdField','dataFormGroupClass' => '','dataSelected' => ' ','label' => __tr('Plan'),'name' => 'plan','required' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'selectize','data-lw-plugin' => 'lwSelectize','id' => 'lwPlanIdField','data-form-group-class' => '','data-selected' => ' ','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Plan')),'name' => 'plan','required' => 'true']); ?>
                         <?php $__env->slot('selectOptions', null, []); ?> 
                            <option value=""><?php echo e(__tr('Select Plan')); ?></option>
                            <?php $__currentLoopData = getPaidPlans(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paidPlanKey => $paidPlan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <optgroup label="<?php echo e($paidPlan['title']); ?> <?php if(!$paidPlan['enabled']): ?> (<?php echo e(__tr('Disabled')); ?>) <?php endif; ?>">
                                <?php $__currentLoopData = $paidPlan['charges']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $planChargeKey => $planCharge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                 <option value="<?php echo e($paidPlanKey); ?>___<?php echo e($planChargeKey); ?>"><?php echo e($paidPlan['title']); ?> - <?php echo e(formatAmount($planCharge['charge'], true)); ?> <?php echo e($planCharge['title']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </optgroup>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                         <?php $__env->endSlot(); ?>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                    <!-- /Plan_Id -->
                    <!-- Ends_At -->
                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['xModel' => 'calculated_ends_at','type' => 'date','id' => 'lwEndsAtField','dataFormGroupClass' => '','label' => __tr('Expiry on'),'name' => 'ends_at','required' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['x-model' => 'calculated_ends_at','type' => 'date','id' => 'lwEndsAtField','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Expiry on')),'name' => 'ends_at','required' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                    <!-- /Ends_At -->
                    <div class="form-group">
                        <label for="lwRemarks"><?php echo e(__tr('Remarks if any')); ?></label>
                        <textarea class="form-control" name="remarks" id="lwRemarks" rows="2"></textarea>
                    </div>
                </div>
                <!-- form footer -->
                <div class="modal-footer">
                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-primary"><?php echo e(__tr('Submit')); ?></button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__tr('Close')); ?></button>
                </div>
                <?php else: ?>
                <div class="alert alert-danger">
                    <?php echo e(__tr('Extended licence required to enable manage subscription')); ?>

                </div>
                <?php endif; ?>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $attributes = $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $component = $__componentOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
            <!--/  New Subscription Form -->
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $attributes = $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $component = $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
        <!--/ New Subscription Modal -->
        </div>
        <div class="col-xl-12">
            <h1><?php echo e(__tr('Manual/Prepaid Subscription Log')); ?></h1>
            <?php if (isset($component)) { $__componentOriginal49c2f9c26fb91807a4f87ab8f845e982 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.datatable','data' => ['dataPageLength' => '10','id' => 'lwManualSubscriptionList','url' => route('central.subscription.manual_subscription.read.list', [
                    'vendorUid' => $vendorIdOrUid
                ])]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.datatable'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data-page-length' => '10','id' => 'lwManualSubscriptionList','url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('central.subscription.manual_subscription.read.list', [
                    'vendorUid' => $vendorIdOrUid
                ]))]); ?>
                <th data-orderable="true" data-name="plan_id"><?php echo e(__tr('Plan')); ?></th>
                <th data-order-by="true" data-order-type="desc" data-orderable="true" data-name="created_at"><?php echo e(__tr('Created At')); ?></th>
                <th data-orderable="true" data-name="ends_at"><?php echo e(__tr('Expiry On')); ?></th>
                <th data-orderable="true" data-name="charges"><?php echo e(__tr('Plan Charges')); ?></th>
                <th data-orderable="true" data-name="charges_frequency"><?php echo e(__tr('Frequency')); ?></th>
                <th data-template="#manualSubscriptionStatusColumnTemplate" data-name="null"><?php echo e(__tr('Status')); ?></th>
                <th data-template="#manualSubscriptionActionColumnTemplate" name="null"><?php echo e(__tr('Action')); ?></th>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982)): ?>
<?php $attributes = $__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982; ?>
<?php unset($__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal49c2f9c26fb91807a4f87ab8f845e982)): ?>
<?php $component = $__componentOriginal49c2f9c26fb91807a4f87ab8f845e982; ?>
<?php unset($__componentOriginal49c2f9c26fb91807a4f87ab8f845e982); ?>
<?php endif; ?>
             <!-- Edit Manual Subscription Modal -->
             <?php if (isset($component)) { $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.modal','data' => ['id' => 'lwEditManualSubscription','header' => __tr('Update Subscription'),'hasForm' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwEditManualSubscription','header' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Update Subscription')),'hasForm' => true]); ?>
                <!--  Edit Manual Subscription Form -->
                <?php if (isset($component)) { $__componentOriginald0b55ee435ec3aeeadffee8b0df479da = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.form','data' => ['id' => 'lwEditManualSubscriptionForm','action' => route('central.subscription.manual_subscription.write.update'),'dataCallbackParams' => ['modalId' => '#lwEditManualSubscription', 'datatableId' => '#lwManualSubscriptionList'],'dataCallback' => 'appFuncs.modelSuccessCallback']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwEditManualSubscriptionForm','action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('central.subscription.manual_subscription.write.update')),'data-callback-params' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['modalId' => '#lwEditManualSubscription', 'datatableId' => '#lwManualSubscriptionList']),'data-callback' => 'appFuncs.modelSuccessCallback']); ?>
                    <!-- form body -->
                    <div id="lwEditManualSubscriptionBody" class="lw-form-modal-body"></div>
                    <script type="text/template" id="lwEditManualSubscriptionBody-template">
                        <?php if($isExtendedLicence): ?>
                        <fieldset>
                            <legend><?php echo e(__tr('Provided Payment Details')); ?></legend>
                            <dl>
                                <dt><?php echo e(__tr('Payment Method')); ?></dt>
                                <dd><%- __tData.__data?.manual_txn_details?.selected_payment_method %></dd>
                                <dt><?php echo e(__tr('Transaction Reference')); ?></dt>
                                <dd><%- __tData.__data?.manual_txn_details?.txn_reference %></dd>
                                <dt><?php echo e(__tr('Transaction Date')); ?></dt>
                                <dd><%- __tData.transactionDate %></dd>
                            </dl>
                        </fieldset>
                        <input type="hidden" name="manualSubscriptionIdOrUid" value="<%- __tData._uid %>" />
                            <!-- form fields -->
                            <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'number','min' => '0','id' => 'lwChargesEditField','dataFormGroupClass' => '','label' => __tr('Charges'),'value' => '<%- __tData.charges %>','name' => 'charges','required' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'number','min' => '0','id' => 'lwChargesEditField','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Charges')),'value' => '<%- __tData.charges %>','name' => 'charges','required' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                    <!-- Ends_At -->
               <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'date','id' => 'lwEndsAtEditField','dataFormGroupClass' => '','label' => __tr('Expiry On'),'value' => '<%- __tData.ends_at %>','name' => 'ends_at','required' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'date','id' => 'lwEndsAtEditField','data-form-group-class' => '','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Expiry On')),'value' => '<%- __tData.ends_at %>','name' => 'ends_at','required' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'selectize','dataLwPlugin' => 'lwSelectize','id' => 'lwSubscriptionStatus','dataFormGroupClass' => '','dataSelected' => '<%- __tData.status %>','label' => __tr('Status'),'name' => 'status','required' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'selectize','data-lw-plugin' => 'lwSelectize','id' => 'lwSubscriptionStatus','data-form-group-class' => '','data-selected' => '<%- __tData.status %>','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Status')),'name' => 'status','required' => 'true']); ?>
                 <?php $__env->slot('selectOptions', null, []); ?> 
                    <option value=""><?php echo e(__tr('Select Status')); ?></option>
                    <?php $__currentLoopData = configItem('subscription_status'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscriptionStatusKey => $subscriptionStatus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($subscriptionStatusKey); ?>"><?php echo e($subscriptionStatus); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                 <?php $__env->endSlot(); ?>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                <div class="form-group">
                    <label for="lwEditRemarks"><?php echo e(__tr('Remarks if any')); ?></label>
                    <textarea class="form-control" name="remarks" id="lwEditRemarks" rows="2"><%- __tData.remarks %></textarea>
                </div>
                    <!-- /Ends_At -->
                    <?php else: ?>
                <div class="alert alert-danger">
                    <?php echo e(__tr('Extended licence required to enable manage subscription')); ?>

                </div>
                <?php endif; ?>
                         </script>
                    <!-- form footer -->
                    <div class="modal-footer">
                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-primary"><?php echo e(__tr('Submit')); ?></button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__tr('Close')); ?></button>
                    </div>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $attributes = $__attributesOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__attributesOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da)): ?>
<?php $component = $__componentOriginald0b55ee435ec3aeeadffee8b0df479da; ?>
<?php unset($__componentOriginald0b55ee435ec3aeeadffee8b0df479da); ?>
<?php endif; ?>
                <!--/  Edit Manual Subscription Form -->
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $attributes = $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $component = $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
            <!--/ Edit Manual Subscription Modal -->
            <script type="text/template" id="manualSubscriptionActionColumnTemplate">
                <a data-pre-callback="appFuncs.clearContainer" title="<?php echo e(__tr('Update')); ?>" class="lw-btn btn btn-sm btn-default lw-ajax-link-action" data-response-template="#lwEditManualSubscriptionBody" href="<%= __Utils.apiURL("<?php echo e(route('central.subscription.manual_subscription.read.update.data', [ 'manualSubscriptionIdOrUid'])); ?>", {'manualSubscriptionIdOrUid': __tData._uid}) %>"  data-toggle="modal" data-target="#lwEditManualSubscription"><i class="fa fa-edit"></i> <?php echo e(__tr('Update')); ?></a>
                <a data-method="post" href="<%= __Utils.apiURL("<?php echo e(route('central.subscription.manual_subscription.write.delete', [ 'manualSubscriptionIdOrUid'])); ?>", {'manualSubscriptionIdOrUid': __tData._uid}) %>" class="btn btn-danger btn-sm lw-ajax-link-action-via-confirm" data-confirm="#lwDeleteManualSubscription-template" title="<?php echo e(__tr('Delete')); ?>" data-callback-params="<?php echo e(json_encode(['datatableId' => '#lwManualSubscriptionList'])); ?>" data-callback="appFuncs.modelSuccessCallback"><i class="fa fa-trash"></i> <?php echo e(__tr('Delete')); ?></a>
            </script>
 <!-- Manual Subscription delete template -->
        <script type="text/template" id="lwDeleteManualSubscription-template">
            <h2><?php echo e(__tr('Are You Sure!')); ?></h2>
            <p><?php echo e(__tr('You want to delete this Subscription?')); ?></p>
    </script>
            <script type="text/template" id="manualSubscriptionStatusColumnTemplate">
                <% if(__tData.status == 'Pending') { %>
                    <span class="badge badge-warning"><?php echo e(__tr('Pending')); ?></span>
                <% } else if(__tData.status == 'Active') { %>
                    <span class="badge badge-success"><?php echo e(__tr('Active')); ?></span>
                <% }  else { %>
                    <%- __tData.status %>
                <% } %>
                <% if(__tData.options.is_expired) { %>
                    <span class="badge badge-danger"><?php echo e(__tr('Expired')); ?></span>
                <% } %>
            </script>
        </div>
    </div>
</div>
<?php endif; ?>
<?php $__env->startPush('appScripts'); ?>
<script>
    (function(window) {
    'use strict';
    $('#lwPlanIdField').on('lwSelectizeOnChange', function(event, value) {
        __DataRequest.post("<?php echo e(route('central.subscription.manual_subscription.read.selected_plan_details')); ?>", {
            'selected_plan' : value
        });
    });
    })(window);
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => __tr('Vendor Details')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/imqsvuod/wala.guru/wbiz/resources/views/vendors/vendor-subscription.blade.php ENDPATH**/ ?>