<?php if($paymentMethod == 'paypal' and ($subscriptionRequestRecord->status == 'initiated')): ?>
<?php if(getAppSettings('enable_paypal')): ?>
<?php if(getAppSettings('use_test_paypal_checkout')): ?>
<script
    src="https://www.paypal.com/sdk/js?client-id=<?= getAppSettings('paypal_checkout_testing_publishable_key') ?>&currency=<?= getAppSettings('currency') ?>">
</script>
<?php else: ?>
<script
    src="https://www.paypal.com/sdk/js?client-id=<?= getAppSettings('paypal_checkout_live_publishable_key') ?>&currency=<?= getAppSettings('currency') ?>">
</script>
<?php endif; ?>
<?php endif; ?>
<?php $__env->startPush('appScripts'); ?>
<script type="text/javascript">
(function() {
    'use strict';
    try {
        var manualSubscriptionUid = "<?php echo e($subscriptionRequestRecord->_uid); ?>";
        paypal.Buttons({
            // Call your server to set up the transaction
            createOrder: function(data, actions) {
                return '<?php echo e($paypalOrderId); ?>';
            },
            // Finalize the transaction on the server after payer approval
            onApprove: function(data) {
                return fetch("<?php echo e(route('capture.paypal.checkout')); ?>", {
                    method: "POST",
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    },
                    body: JSON.stringify({
                        "orderUID": data.orderID,
                        "manualSubscriptionUid": manualSubscriptionUid,
                    })
                })
                .then((response) => {
                    return response.json();
                })
                .then((orderData) => {
                    // Successful capture! For dev/demo purposes:
                    window.location = orderData.data.redirectRoute;
                });
            },
            onError: function(err) {
                // Show an error page here, when an error occurs
                showAlert(JSON.stringify(err.message, null, 2), 'error');
            },
            onCancel: function(data) {
                showAlert("<?php echo e(__tr('User cancelled payment.')); ?>", 'error');
                // Optionally show a cancellation message or update the UI
            }
        }).render('#paypal-button-container');
    } catch (error) {
            if ('<?php echo e(getAppSettings('enable_paypal')); ?>') {
                showAlert(error, 'error');
            }
        }
    })();
    </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH /home/imqsvuod/wala.guru/wbiz/resources/views/subscription/manual-subscription/paypal-partial.blade.php ENDPATH**/ ?>