<?php
/**
* Component : WhatsAppService
* Controller : WhatsAppServiceController
* File : templates.list.blade.php
----------------------------------------------------------------------------- */
?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('users.partials.header', [
'title' => __tr('WhatsApp Templates'),
'description' => '',
'class' => 'col-lg-7'
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<div class="container-fluid mt-lg--6">
    <div class="row">
        <!-- button -->
        <div class="col-xl-12 mb-3">
           <div class="float-right">
            <a class="lw-btn btn btn-primary" href="<?php echo e(route('vendor.whatsapp_service.templates.read.new_view')); ?>" > <?php echo e(__tr('Create New Template')); ?></a>
            <a class="lw-btn btn btn-dark lw-ajax-link-action" data-callback="reloadDtOnSuccess" data-method="post" href="<?php echo e(route('vendor.whatsapp_service.templates.write.sync')); ?>" > <?php echo e(__tr('Sync WhatsApp Templates')); ?></a>
            <a class="lw-btn btn btn-default" target="_blank" href="https://business.facebook.com/wa/manage/message-templates/?waba_id=<?php echo e(getVendorSettings('whatsapp_business_account_id')); ?>" > <?php echo e(__tr('Manage Templates on Meta')); ?> <i class="fas fa-external-link-alt"></i></a>
           </div>
        </div>
        <!--/ button -->
        <?php if (isset($component)) { $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.modal','data' => ['id' => 'lwTemplatePreview','header' => __tr('Template Preview'),'modalSize' => 'modal-sm','hasForm' => true,'xData' => '{selectedTemplate:\'\'}']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwTemplatePreview','header' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Template Preview')),'modalSize' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('modal-sm'),'hasForm' => true,'x-data' => '{selectedTemplate:\'\'}']); ?>
            <!--  Edit Contact Form -->
            <div id="lwTemplatePreviewForm">
                <!-- form body -->
                <div id="lwTemplateStructureContainer" class="lw-form-modal-body"></div>
                <!-- form footer -->
                <div class="modal-footer" id="lwTemplateStructureContainerActions"></div>
                <script type="text/template" id="lwTemplateStructureContainerActions-template">
                    <% if(__tData.template_status == 'APPROVED') { %>
                    <a title="<?php echo e(__tr('Create Campaign using this template')); ?>" class="lw-btn btn btn-primary"  href="<?php echo e(route('vendor.campaign.new.view')); ?>?use_template=<%- __tData._uid %>"><i class="fa fa-bullhorn"></i> <?php echo e(__tr('Create Campaign')); ?></a>
                    <% } %>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__tr('Close')); ?></button>
                </script>
            </div>
            <!--/  Edit Contact Form -->
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $attributes = $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $component = $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
        <div class="col-xl-12">
            <?php if (isset($component)) { $__componentOriginal49c2f9c26fb91807a4f87ab8f845e982 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.datatable','data' => ['id' => 'lwTemplatesList','dataPageLength' => '100','url' => route('vendor.whatsapp_service.templates.read.list')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.datatable'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwTemplatesList','data-page-length' => '100','url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('vendor.whatsapp_service.templates.read.list'))]); ?>
                <th data-orderable="true" data-name="template_name"><?php echo e(__tr('Name')); ?></th>
                <th data-orderable="true" data-name="language"><?php echo e(__tr('Language')); ?></th>
                <th data-orderable="true" data-name="category"><?php echo e(__tr('Category')); ?></th>
                <th data-template="#templatesStatusColumnTemplate" name="null"><?php echo e(__tr('Status')); ?></th>
                <th data-orderable="true" data-order-by="true" data-order-type="desc" data-name="updated_at"><?php echo e(__tr('Updated On')); ?></th>
                <th data-template="#templatesActionColumnTemplate" name="null"><?php echo e(__tr('Action')); ?></th>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982)): ?>
<?php $attributes = $__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982; ?>
<?php unset($__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal49c2f9c26fb91807a4f87ab8f845e982)): ?>
<?php $component = $__componentOriginal49c2f9c26fb91807a4f87ab8f845e982; ?>
<?php unset($__componentOriginal49c2f9c26fb91807a4f87ab8f845e982); ?>
<?php endif; ?>
        </div>
        <script type="text/template" id="templatesStatusColumnTemplate">
            <% if(__tData.status == 'APPROVED') { %>
                <span class="text-success"><i class="fa fa-check-circle text-success"></i> <?php echo e(__tr('APPROVED')); ?></span>
            <% } else if(__tData.status == 'REJECTED') { %>
                <span class="text-danger"><i class="fa fa-times-circle text-danger"></i> <?php echo e(__tr('REJECTED')); ?></span>
            <% } else if(__tData.status == 'PENDING') { %>
                <span class="text-warning"><i class="fa fa-clock text-warning"></i> <?php echo e(__tr('PENDING')); ?></span>
            <% } else { %>
                <%- __tData.status  %>
            <% } %>
        </script>
        <!-- action template -->
        <script type="text/template" id="templatesActionColumnTemplate">
            <% if(__tData.status == 'APPROVED') { %>
            <a title="<?php echo e(__tr('Create Campaign using this template')); ?>" class="lw-btn btn btn-sm btn-primary"  href="<?php echo e(route('vendor.campaign.new.view')); ?>?use_template=<%- __tData._uid %>"><i class="fa fa-bullhorn"></i> <?php echo e(__tr('Create Campaign')); ?></a>
            <% } %>
            
            <a data-pre-callback="appFuncs.clearContainer" title="<?php echo e(__tr('Template Preview')); ?>" class="lw-btn btn btn-sm btn-light lw-ajax-link-action" data-method="post" data-post-data="<%- toJsonString({'template_selection': __tData._uid,'template_status': __tData.status}) %>" data-response-template="#lwTemplateStructureContainerActions" href="<?php echo e(route('vendor.request.template.view')); ?>?only-preview=1"  data-toggle="modal" data-target="#lwTemplatePreview"><i class="fa fa-eye"></i> <?php echo e(__tr('Preview')); ?></a>
            
            <div class="btn-group">
                <a title="<?php echo e(__tr('Edit Template')); ?>" class="lw-btn btn btn-sm btn-default" href="<%= __Utils.apiURL("<?php echo e(route('vendor.whatsapp_service.templates.read.update_view',['whatsappTemplateUid'])); ?>", {'whatsappTemplateUid': __tData._uid}) %>"><?php echo e(__tr('Edit')); ?></a>
                <button type="button" class="btn btn-sm btn-secondary dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-expanded="false">
                  <span class="sr-only"><?php echo e(__tr('Toggle Dropdown')); ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-right">
                    <a target="_blank" title="<?php echo e(__tr('Edit Template on Meta')); ?>" class="dropdown-item" href="https://business.facebook.com/wa/manage/message-templates/?&waba_id=<?php echo e(getVendorSettings('whatsapp_business_account_id')); ?>&id=<%- __tData.template_id %>"><?php echo e(__tr('Edit Template on Meta')); ?> <i class="fas fa-external-link-alt"></i></a>
                </div>
              </div>
            <a title="<?php echo e(__tr('Delete Template')); ?>" data-callback="reloadDtOnSuccess" data-method="post" data-confirm="#lwConfirmTemplateDelete" data-confirm-params="<%- toJsonString({'templateName': __tData.template_name}) %>" class="lw-btn btn btn-sm btn-danger lw-ajax-link-action" href="<%= __Utils.apiURL(" <?php echo e(route('vendor.whatsapp_service.templates.write.delete',['whatsappTemplateUid'])); ?>", {'whatsappTemplateUid': __tData._uid}) %>"><?php echo e(__tr('Delete')); ?></a>
        </script>
        <!-- /action template -->
        <script type="text/template" id="lwConfirmTemplateDelete">
            <h3><?php echo __tr('Are you sure you want to delete __templateName__ template', [
                '__templateName__' => '<strong><%- __tData.templateName %></strong>'
                ]); ?></h3>
        </script>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['title' => __tr('Templates List')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/workwatsup-new.jmd-infotech.in/resources/views/whatsapp-service/templates-list.blade.php ENDPATH**/ ?>