<?php
$vendorId = getVendorId();
// check the feature limit
$vendorPlanDetails = vendorPlanDetails('api_access', 0, $vendorId);
?>
<div class="row">
    <div class="col-md-8" x-cloak>
    <!-- Page Heading -->
    <h1>
        <?= __tr('API Access & Webhook') ?>
    </h1>
    <fieldset>
        <legend><?php echo e(__tr('Webhook Endpoint')); ?></legend>
        <p><?php echo e(__tr('WhatsApp webhook payload will be forwarded to following endpoint via POST method')); ?></p>
        <?php if($vendorPlanDetails['is_limit_available']): ?>
        <form class="lw-ajax-form lw-form" method="post" action="<?= route('vendor.settings.write.update', ['pageType' => 'vendor_webhook']) ?>" >
            <div class="my-4" x-cloak x-data="{lwVendorEndpointShow:<?php echo e(getVendorSettings('enable_vendor_webhook') ? 1 : 0); ?>}">
                <?php if (isset($component)) { $__componentOriginal85a79a3f590ffcc2d6473eb3120eb493 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.checkbox','data' => ['@click' => 'lwVendorEndpointShow = !lwVendorEndpointShow','id' => 'enableWebhookEndpoint','name' => 'enable_vendor_webhook','checked' => getVendorSettings('enable_vendor_webhook'),'dataLwPlugin' => 'lwSwitchery','label' => __tr('Enable Webhook Endpoint')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.checkbox'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['@click' => 'lwVendorEndpointShow = !lwVendorEndpointShow','id' => 'enableWebhookEndpoint','name' => 'enable_vendor_webhook','checked' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(getVendorSettings('enable_vendor_webhook')),'data-lw-plugin' => 'lwSwitchery','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Enable Webhook Endpoint'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493)): ?>
<?php $attributes = $__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493; ?>
<?php unset($__attributesOriginal85a79a3f590ffcc2d6473eb3120eb493); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal85a79a3f590ffcc2d6473eb3120eb493)): ?>
<?php $component = $__componentOriginal85a79a3f590ffcc2d6473eb3120eb493; ?>
<?php unset($__componentOriginal85a79a3f590ffcc2d6473eb3120eb493); ?>
<?php endif; ?>
                <div x-show="lwVendorEndpointShow">
                    <?php if (isset($component)) { $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.input-field','data' => ['type' => 'text','id' => 'lwWebhookEndpoint','dataFormGroupClass' => '','value' => ''.e(getVendorSettings('vendor_webhook_endpoint')).'','label' => __tr('Webhook Endpoint'),'name' => 'vendor_webhook_endpoint']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.input-field'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'text','id' => 'lwWebhookEndpoint','data-form-group-class' => '','value' => ''.e(getVendorSettings('vendor_webhook_endpoint')).'','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Webhook Endpoint')),'name' => 'vendor_webhook_endpoint']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $attributes = $__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__attributesOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69)): ?>
<?php $component = $__componentOriginalc48421d24039f3f08f3bb9a3b9254b69; ?>
<?php unset($__componentOriginalc48421d24039f3f08f3bb9a3b9254b69); ?>
<?php endif; ?>
                </div>
                
                
                <div>
                    <button type="submit" href class="mt-2 btn btn-primary btn-user lw-btn-block-mobile"><?php echo e(__tr('Save')); ?></button>
                </div>
            </div>
        </form>
        <?php else: ?>
            <div class="alert alert-danger">
                <?php echo e(__tr('API/Webhook Access is not available in your plan, please upgrade your subscription plan.')); ?>

            </div>
        <?php endif; ?>
        <h3><?php echo e(__tr('Example Webhook Response')); ?></h3>
<pre>
<code>
{
    "contact": {
        "status": "existing/updated/new",
        "phone_number": "XXXXXXXXXX",
        "uid": "XXXXXXXXXX",
        "first_name": "XXXXXXXXXX",
        "last_name": "XXXXXXXXXX",
        "email": "XXXXXX@XXXXXXXXXX.com",
        "language_code": "en",
        "country": "XXXX"
    },
      "message": {
        "whatsapp_business_phone_number_id": "XXXXXXXXXX",
        "whatsapp_message_id": "wamid.XXXXXXXXXX",
        "replied_to_whatsapp_message_id": "wamid.XXXXXXXXXX",
        "is_new_message": true,
        "body": null,
        "status": null,
        "media": {
          "type": "image",
          "link": "link to media",
          "caption": null,
          "mime_type": "image/jpeg",
          "file_name": "XXXXXXXXXX",
          "original_filename": "XXXXXXXXXX"
        }
      },
    "whatsapp_webhook_payload": {
        // WhatsApp webhook data
    }
}
</code>
</pre>
    </fieldset>
    <fieldset class="lw-fieldset mb-3" >
        <legend><?php echo e(__tr('Your Account Access API')); ?></legend>
        <p><?php echo e(__tr('Access token is required to use available APIs')); ?></p>
            <p>
                <?php echo e(__tr('You need to pass access token as bearer token in header or \'token\' as your url parameter')); ?>

            </p>
            <div>
                <?php if($vendorPlanDetails['is_limit_available']): ?>
                <div class="col-12 p-0">
                    <h3><?php echo __tr('API Access Token'); ?></h3>
                    <?php if(getVendorSettings('vendor_api_access_token')): ?>
                    <div class="input-group">
                        <input type="text" class="form-control" readonly id="lwAccessToken" value='<?php echo e(getVendorSettings('vendor_api_access_token')); ?>'>
                        <div class="input-group-append">
                            <button class="btn btn-outline-light" type="button" onclick="lwCopyToClipboard('lwAccessToken')">
                                <?= __tr('Copy') ?>
                            </button>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="alert alert-light">
                        <?php echo e(__tr('No token generated yet.')); ?>

                    </div>
                    <?php endif; ?>
                </div>
                <script type="text/template" id="lwRegenerateTokenAlert">
                    <h3><?php echo e(__tr('Generate New Token?')); ?></h3>
                    <p><?php echo e(__tr('Your existing tokens will be void immediately')); ?></p>
                </script>
                <form class="lw-ajax-form lw-form" <?php if(getVendorSettings('vendor_api_access_token')): ?> data-confirm="#lwRegenerateTokenAlert" <?php endif; ?> method="post" action="<?= route('vendor.settings.write.update', ['pageType' => 'internals']) ?>" >
                    <div class="my-4">
                        <input type="hidden" name="vendor_api_access_token" value="<?php echo e(Str::random(64)); ?>">
                        
                        <button type="submit" href class="btn btn-primary btn-user lw-btn-block-mobile">
                            <i class="fa fa-key"></i> <?php echo e(__tr('Generate New Token')); ?>

                        </button>
                    </div>
                    </form>
                    <div>
                        <hr>
                        <h3><?php echo e(__tr('API Endpoint Information')); ?></h3>
                        <div class="form-group">
                            <label for="lwApiBaseUrl"><?php echo e(__tr('API Base URL')); ?></label>
                            <div class="input-group">
                                <input type="text" class="form-control" readonly id="lwApiBaseUrl" value='<?php echo e(route('api.base_url')); ?>'>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-light" type="button" onclick="lwCopyToClipboard('lwApiBaseUrl')">
                                        <?= __tr('Copy') ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="lwVendorUid"><?php echo e(__tr('Your Vendor UID')); ?></label>
                            <div class="input-group">
                                <input type="text" class="form-control" readonly id="lwVendorUid" value='<?php echo e(getVendorUid()); ?>'>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-light" type="button" onclick="lwCopyToClipboard('lwVendorUid')">
                                        <?= __tr('Copy') ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="lwExampleEndpoint"><?php echo e(__tr('Example Endpoint for Send Message it will consist of API base url, vendor uid and token. You can also pass token as Bearer Token')); ?></label>
                            <div class="input-group">
                                <input type="text" class="form-control" readonly id="lwExampleEndpoint" value='<?php echo e(route('api.vendor.chat_message.send.process', [
                                    'vendorUid' => getVendorUid()
                                ])); ?>?token=<?php echo e(getVendorSettings('vendor_api_access_token')); ?>'>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-light" type="button" onclick="lwCopyToClipboard('lwExampleEndpoint')">
                                        <?= __tr('Copy') ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="alert alert-danger">
                        <?php echo e(__tr('API/Webhook Access is not available in your plan, please upgrade your subscription plan.')); ?>

                    </div>
                <?php endif; ?>
            </div>
        </fieldset>
        <fieldset>
            <legend><?php echo e(__tr('API Documentation')); ?></legend>
            <fieldset>
                <legend><?php echo e(__tr('Variables and Parameters')); ?></legend>
                <h4><?php echo e(__tr('Contact Related Dynamic Parameters')); ?></h4>
                <div class="help-text my-3 border p-3"><?php echo e(__tr('You are free to use following dynamic variables for parameters excluding phone_number, template_name, template_language, which will get replaced with contact\'s concerned field value.')); ?> <div><code><?php echo e(implode(' ', $dynamicFields)); ?></code></div></div>
                <h3><?php echo e(__tr('Example Parameters')); ?></h3>
<pre>
<code>
{
    "from_phone_number_id": "phone number id from which you would like to send message, if not provided default one will be used",
    "phone_number": "phone number with country code without prefixing + or 0",
    "template_name" : "your_template_name",
    "template_language" : "en",
    "header_image" : "https://cdn.pixabay.com/photo/2015/01/07/15/51/woman-591576_1280.jpg",
    "header_video" : "https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerEscapes.mp4",
    "header_document" : "https://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerEscapes.mp4",
    "header_document_name" : "{full_name}",
    "header_field_1" : "{full_name}",
    "location_latitude" : "22.22",
    "location_longitude" : "22.22",
    "location_name" : "Example Name",
    "location_address" : "Example address",
    "field_1" : "{first_name}",
    "field_2" : "{last_name}",
    "field_3" : "{email}",
    "field_4" : "{country}",
    "field_5" : "{language_code}",
    "button_0" : "{full_name}",
    "button_1" : "{phone_number}",
    "copy_code" : "EXAMPLE_CODE"
}
</code>
</pre>
            </fieldset>
            <div class="my-4">
                <h3><?php echo e(__tr('Click on the button below for API information')); ?></h3>
            <a target="_blank" href="<?php echo e(getAppSettings('api_documentation_url')); ?>" class="btn btn-info lw-white-space-normal lw-btn-breakable"> <i class="fa fa-book"></i> <?php echo e(__tr('API Documentation')); ?> - <?php echo e(getAppSettings('api_documentation_url')); ?></a>
            </div>
        </fieldset>
</div>
</div><?php /**PATH /home/imqsvuod/wala.guru/wbiz/resources/views/vendors/settings/api-access.blade.php ENDPATH**/ ?>