<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('users.partials.header', [
    'title' => __tr('My Subscription'),
    'description' => '',
    'class' => 'col-lg-7'
    ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php $isExtendedLicence = (getAppSettings('product_registration', 'licence') === 'dee257a8c3a2656b7d7fbe9a91dd8c7c41d90dc9'); ?>
   <?php if(isset($message)): ?>
    <div class="container">
        <div class="alert alert-danger">
            <?php echo e($message); ?>

        </div>
    </div>
   <?php else: ?>
   <?php
   $subscriptionPlans = getAppSettings('subscription_plans');
   $isManualSubscription = $currentSubscription?->plan_id ? true : false;
   $isCashierSubscription = $currentSubscription?->stripe_status ? true : false;
   $hasPlansForPurchase = false;

   foreach ($planStructure as $planKey => $plan) {
       $plan = $planDetails[$planKey];
       if (!$plan['enabled']) {
           continue;
       }
       $hasPlansForPurchase = true;
       break;
   }
   ?>
   <div class="container-fluid pb-5">
       <div class="row">
           <div class="col-xl-12">
            <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
            <?php if(getAppSettings('enable_stripe') and !$isValidStripeKeys): ?>
               <div class="alert alert-danger">
                    <?php echo e(__tr('Stripe is not correctly configured, Invalid Keys. Please contact administrator')); ?>

               </div>
               <?php endif; ?>
               <div class="card mb-4">
                   <div class="card-body">
                       <?php if(request('success') == true and request('message')): ?>
                           <div class="alert alert-success">
                               <?php echo e(request('message')); ?>

                           </div>
                       <?php elseif(request('message')): ?>
                           <div class="alert alert-warning">
                               <?php echo e(request('message')); ?>

                           </div>
                       <?php endif; ?>
                       <?php if($currentPlan and ($isManualSubscription or $subscriber->subscribed($currentPlan['id']))): ?>
                           <?php if($subscriber->subscription($currentPlan['id'])?->onTrial()): ?>
                               <div class="alert alert-warning">
                                   <?php echo e(__tr('You are on trial until __trialEndsAt__', [
                                       '__trialEndsAt__' => formatDateTime($subscriber->trialEndsAt($currentPlan['id']))
                                   ])); ?>

                               </div>
                           <?php endif; ?>
                           <?php if($subscriber->subscription($currentPlan['id'])?->onGracePeriod()): ?>
                               <div class="alert alert-warning">
                                   <?php echo e(__tr('Subscription has been cancelled and you are on the grace period till __endsAt__', [
                                       '__endsAt__' => formatDateTime($subscriber->subscription($currentPlan['id'])->ends_at)
                                   ])); ?>

                               </div>
                           <?php endif; ?>
                           <fieldset class="mb-4">
                               <legend><?php echo e(__tr('Current Plan')); ?></legend>
                               <h2 class="text-primary"><?php echo e($planDetails[$currentPlan['id']]['title']); ?></h2>
                               <?php $__currentLoopData = $planStructure[$currentPlan['id']]['features']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featureKey => $featureValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                   <?php
                                        $structureFeatureValue = $featureValue;
                                       $featureValue = $planDetails[$currentPlan['id']]['features'][$featureKey];
                                   ?>
                                   <div class="my-2">
                                    <?php if(isset($featureValue['type']) and ($featureValue['type'] == 'switch')): ?>
                                        <?php if(isset($featureValue['limit']) and $featureValue['limit']): ?>
                                        <i class="fa fa-check mr-2 text-success"></i>
                                        <?php else: ?>
                                        <i class="fa fa-times mr-2 text-danger"></i>
                                        <?php endif; ?>
                                        <?php echo e(($structureFeatureValue['description'])); ?>

                                        <?php else: ?>
                                       <i class="fa fa-check text-success mr-2"></i>
                                       <?php if(isset($featureValue['limit']) and $featureValue['limit'] < 0): ?>
                                           <?php echo e(__tr('Unlimited')); ?>

                                       <?php elseif(isset($featureValue['limit'])): ?>
                                           <?php echo e($featureValue['limit']); ?>

                                       <?php endif; ?>
                                       <?php echo e(($structureFeatureValue['description'])); ?>

                                       <?php if(isset($featureValue['limit_duration_title'])): ?>
                                            <?php echo e(($featureValue['limit_duration_title'])); ?>

                                        <?php endif; ?>
                                        <?php endif; ?>
                                   </div>
                               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                               <?php if($currentSubscription->charges): ?>
                               <label class="my-3 text-primary">
                                <?php echo e(formatAmount($currentSubscription->charges, true)); ?> / <?php echo e($planDetails[$currentPlan['id']]['charges'][$currentSubscription->charges_frequency]['title'] ?? $currentSubscription->charges_frequency ?? ''); ?>

                            </label>
                               <?php else: ?>
                               <?php $__currentLoopData = $planDetails[$currentPlan['id']]['charges']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itemKey => $itemValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                   <?php if($planSelectorId === $currentPlan['id'] . '___' . $itemKey): ?>
                                       <label class="my-3 text-primary">
                                           <?php echo e(formatAmount($itemValue['charge'], true)); ?> /
                                           <?php echo e($itemKey); ?>

                                       </label>
                                   <?php endif; ?>
                               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                               <?php endif; ?>
                           </fieldset>
                           <?php if($currentSubscription->ends_at ?? null): ?>
                               <h4 class="text-orange"><?php echo e(__tr('Expiry Date: __expiryDate__', [
                                '__expiryDate__' => formatDate($currentSubscription->ends_at)
                               ])); ?></h4>
                           <?php endif; ?>
                           <?php if($isCashierSubscription and !$subscriber->subscription($currentPlan['id'])?->canceled()): ?>
                               <a data-show-processing="true" class="lw-ajax-link-action btn btn-danger" href="<?php echo e(route('subscription.write.cancel')); ?>">
                                   <?php echo e(__tr('Cancel Subscription')); ?>

                               </a>
                           <?php endif; ?>
                            <!-- For Recurring Payment Only -->
                            <?php echo $__env->yieldPushContent('autoCancelSubscriptionStack'); ?>
                            <!-- /For Recurring Payment Only -->
                       <?php else: ?>
                           <?php if($freePlanDetails['enabled']): ?>
                               <fieldset class="mb-4">
                                   <legend><?php echo e(__tr('Current Plan')); ?></legend>
                                   <h2 class="text-primary"><?php echo e($freePlanDetails['title']); ?></h2>
                                   <?php $__currentLoopData = $freePlanStructure['features']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featureKey => $featureValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                       <?php
                                            $structureFeatureValue = $featureValue;
                                           $featureValue = $freePlanDetails['features'][$featureKey];
                                       ?>
                                       <div class="my-2">
                                        <?php if(isset($featureValue['type']) and ($featureValue['type'] == 'switch')): ?>
                                        <?php if(isset($featureValue['limit']) and $featureValue['limit']): ?>
                                        <i class="fa fa-check mr-2 text-success"></i>
                                        <?php else: ?>
                                        <i class="fa fa-times mr-2 text-danger"></i>
                                        <?php endif; ?>
                                        <?php echo e(($structureFeatureValue['description'])); ?>

                                        <?php else: ?>
                                           <i class="fa fa-check text-success mr-2"></i>
                                           <?php if(isset($featureValue['limit']) and $featureValue['limit'] < 0): ?>
                                               <?php echo e(__tr('Unlimited')); ?>

                                           <?php elseif(isset($featureValue['limit'])): ?>
                                               <?php echo e($featureValue['limit']); ?>

                                           <?php endif; ?>
                                           <?php echo e(($structureFeatureValue['description'])); ?>

                                           <?php if(isset($featureValue['limit_duration_title'])): ?>
                                                <?php echo e(($featureValue['limit_duration_title'])); ?>

                                            <?php endif; ?>
                                            <?php endif; ?>
                                       </div>
                                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                               </fieldset>
                           <?php else: ?>
                               <div class="alert alert-warning">
                                   <?php echo e(__tr('There are no active plan')); ?>

                               </div>
                           <?php endif; ?>
                       <?php endif; ?>
                       <?php if(getAppSettings('enable_stripe') and $isValidStripeKeys and $isCashierSubscription): ?>
                       <a class="btn btn-default" href="<?php echo e(route('subscription.read.billing_portal')); ?>">
                           <?php echo e(__tr('Go to Billing Portal')); ?>

                       </a>
                       <?php if($currentPlan and $isCashierSubscription and $subscriber->subscription($currentPlan['id']) and $subscriber->subscription($currentPlan['id'])->canceled() and $subscriber->subscription($currentPlan['id'])->onGracePeriod()): ?>
                           <a data-show-processing="true" class="lw-ajax-link-action btn btn-success"
                               href="<?php echo e(route('subscription.write.resume')); ?>">
                               <?php echo e(__tr('Resume Subscription')); ?>

                           </a>
                           <div class="note text-muted my-2">
                               <?php echo e(__tr('You will be able to resume subscription while on grace period')); ?></div>
                       <?php endif; ?>

                       <?php if($currentPlan and $isCashierSubscription and $subscriber->hasIncompletePayment($currentPlan['id'])): ?>
                           <div>
                               <a data-show-processing="true" class="lw-ajax-link-action btn btn-primary"
                                   href="<?php echo e(route('cashier.payment', $subscriber->latestPayment()->id)); ?>">
                                   <?php echo e(__tr('Please confirm your payment.')); ?>

                               </a>
                           </div>
                       <?php endif; ?>
                       <?php endif; ?>
                   </div>
               </div>
               <?php if($currentPlan and $hasPlansForPurchase): ?>
                   <div class="card">
                       <div class="card-header">
                           <?php echo e(__tr('Change Plan')); ?>

                       </div>
                       <div class="card-body" x-data="{selectedPlanFrequencyNew:null}">
                            <div class="row">
                               <?php $__currentLoopData = $planStructure; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $planKey => $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                   <?php
                                       $planId = $plan['id'];
                                       $features = $plan['features'];
                                       $plan = $planDetails[$planKey];
                                       if (!$plan['enabled']) {
                                           continue;
                                       }
                                   ?>
                                   <div class="col-xl-4 col-sm-12">
                                    <fieldset class="">
                                        <legend><?php echo e($plan['title']); ?></legend>
                                        <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featureKey => $featureValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $structureFeatureValue = $featureValue;
                                                $featureValue = $planDetails[$planKey]['features'][$featureKey];
                                            ?>
                                            <div class="my-2">
                                             <?php if(isset($featureValue['type']) and ($featureValue['type'] == 'switch')): ?>
                                         <?php if(isset($featureValue['limit']) and $featureValue['limit']): ?>
                                         <i class="fa fa-check mr-2 text-success"></i>
                                         <?php else: ?>
                                         <i class="fa fa-times mr-2 text-danger"></i>
                                         <?php endif; ?>
                                         <?php echo e(($structureFeatureValue['description'])); ?>

                                         <?php else: ?>
                                                <i class="fa fa-check text-success mr-2"></i>
                                                <?php if(isset($featureValue['limit']) and $featureValue['limit'] < 0): ?>
                                                    <?php echo e(__tr('Unlimited')); ?>

                                                <?php elseif(isset($featureValue['limit'])): ?>
                                                    <?php echo e($featureValue['limit']); ?>

                                                    <?php if(isset($featureValue['limit_duration'])): ?>
                                                 <?php echo e(($featureValue['limit_duration'])); ?>

                                             <?php endif; ?>
                                                <?php endif; ?>
                                                <?php echo e(($structureFeatureValue['description'])); ?>

                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <div class="text-lg mt-4">
                                            <?php $__currentLoopData = $plan['charges']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itemKey => $itemValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                if(!$itemValue['enabled']) {
                                                    continue;
                                                }
                                            ?>
                                                <?php if($planSelectorId !== $planId . '___' . $itemKey): ?>
                                                    <div class="form-group my-2 text-primary">
                                                        <label class="control-label" for="<?php echo e($planId); ?><?php echo e($itemKey); ?>">
                                                            <input x-model="selectedPlanFrequencyNew" class="form-control-radio" type="radio" name="plan"
                                                            id="<?php echo e($planId); ?><?php echo e($itemKey); ?>"
                                                            value="<?php echo e($planId); ?>___<?php echo e($itemKey); ?>">
                                                            <?php echo e(formatAmount($itemValue['charge'], true)); ?> /
                                                            <?php echo e($planStructure[$planId]['charges'][$itemKey]['title'] ?? $itemKey); ?>

                                                        </label>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </fieldset>
                                   </div>
                               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                               <?php if($isCashierSubscription && getAppSettings('enable_stripe') and $isValidStripeKeys): ?>
                               <form class="lw-ajax-form" data-show-processing="true" action="<?php echo e(route('subscription.write.change')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="plan" x-model="selectedPlanFrequencyNew">
                                <button value="stripe" type="submit" class="mt-4 btn btn-primary">
                                    <?php echo e(__tr('Change Plan')); ?>

                                </button>
                                </form>
                               <?php else: ?>
                               <?php if(getAppSettings('enable_upi_payment') or getAppSettings('enable_bank_transfer')): ?>
                               <fieldset>
                                <!-- ---------- This form for when change Subscription -------------- -->
                                <legend><?php echo e(__tr('Manual/Prepaid Subscription')); ?></legend>
                                <?php if($existingManualSubscriptionPendingRequest): ?>
                                <div class="alert alert-danger my-5">
                                 <?php echo e(__tr('Your already have pending request for manual subscription change, please wait once it get confirmed')); ?>

                                </div>
                                <?php else: ?>
                                  <form action="<?php echo e(route('vendor.subscription_manual_pay')); ?>" method="post" id="manual-pay-form">
                                        <?php echo csrf_field(); ?>
                                        
                                        <input type="hidden" name="selected_plan" x-model="selectedPlanFrequencyNew">
                                        
                                        <?php if(getAppSettings('enable_paypal')): ?>
                                        <label for="lPaypalPaymentOption" class="mr-4"><h3><input type="radio" id="lPaypalPaymentOption" name="payment_method" value="paypal"><img height="100" src="<?php echo e(asset('imgs/pay_pal.png')); ?>"> </h3></label>
                                        <?php endif; ?>
                                        
                                        
                                        <?php if(getAppSettings('enable_razorpay')): ?>
                                        <label for="lwRazorpayPaymentOption" class="mr-4"><h3><input type="radio" id="lwRazorpayPaymentOption" name="payment_method" value="razorpay"><img height="40" src="<?php echo e(asset('imgs/razorpay.png')); ?>"> </h3></label>
                                        <?php endif; ?>
                                        
                                        
                                        <?php if(getAppSettings('enable_upi_payment')): ?>
                                            <label for="lwUpiPaymentOption" class="mr-4"><h3><input type="radio" id="lwUpiPaymentOption" name="payment_method" value="upi"> <?php echo e(__tr('Pay with any UPI')); ?> <img height="100" src="<?php echo e(asset('imgs/upi-icon.png')); ?>"> </h3></label>
                                        <?php endif; ?>
                                        
                                        
                                        <?php if(getAppSettings('enable_bank_transfer')): ?>
                                            <label for="lwBankTransferPaymentOption" class="mr-4"><h3><input type="radio" id="lwBankTransferPaymentOption" name="payment_method" value="bank_transfer"> <?php echo e(__tr('Pay with Bank Transfer')); ?> <img height="100" src="<?php echo e(asset('imgs/bank-transfer.svg')); ?>"> </h3></label>
                                        <?php endif; ?>
                                        
                                        
                                          
                                          <?php if(getAppSettings('enable_paystack')): ?>
                                          <label for="lwPaystackPaymentOption" class="mr-4"><h3><input type="radio" id="lwPaystackPaymentOption" name="payment_method" value="paystack"> <img height="100" src="<?php echo e(asset('imgs/paystack-icon.png')); ?>"></h3></label>
                                      <?php endif; ?>
                                       
                
                                       <?php if(getAppSettings('enable_yoomoney')): ?>
                                       <label for="lwYooMoneyPaymentOption" class="mr-4"><h3><input type="radio" id="lwYooMoneyPaymentOption" name="payment_method" value="yoomoney"><img height="100" width="90" src="<?php echo e(asset('imgs/yoomoney.png')); ?>"> </h3></label>
                                       <?php endif; ?>
                                      
                                      
                                        <div class="my-3">
                                            <hr>
                                            <button type="submit" class="btn btn-primary btn-lg " href=""><?php echo e(__tr('Continue')); ?></button>
                                           </div>
                                    </form>
                                    <?php endif; ?>
                                    <!-- ----------/change Subscription -------------- -->
                                </fieldset>
                                <?php endif; ?>
                               <?php endif; ?>
                       </div>
                   </div>
               <?php endif; ?>
               <?php if(!$currentPlan): ?>
                   <div class="card">
                    <div class="card-header">
                        <?php echo e(__tr('Subscribe Paid Plans')); ?>

                    </div>
                       <div class="card-body py-0" x-data="{selectedPlanFrequencyNew:null}">
                               <div class="form-group">
                                   <div class="mb-4 row">
                                       <?php $__currentLoopData = $planStructure; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $planKey => $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                           <?php
                                               $planId = $plan['id'];
                                               $features = $plan['features'];
                                               $charges = $planDetails[$planKey]['charges'];
                                               if (!$planDetails[$planKey]['enabled']) {
                                                   continue;
                                               }
                                           ?>
                                           <div class="col-xl-4 col-sm-12">
                                           <fieldset class="">
                                               <legend><?php echo e($planDetails[$planKey]['title']); ?></legend>
                                               <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featureKey => $featureValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                   <?php
                                                       $featureValue = $planDetails[$planKey]['features'][$featureKey];
                                                   ?>
                                                   <div class="my-2">
                                                    <?php if(isset($featureValue['type']) and ($featureValue['type'] == 'switch')): ?>
                                                    <?php if(isset($featureValue['limit']) and $featureValue['limit']): ?>
                                                    <i class="fa fa-check mr-2 text-success"></i>
                                                    <?php else: ?>
                                                    <i class="fa fa-times mr-2 text-danger"></i>
                                                    <?php endif; ?>
                                                    <?php echo e(($featureValue['description'])); ?>

                                                    <?php else: ?>
                                                       <i class="fa fa-check text-success mr-2"></i>
                                                       <?php if(isset($featureValue['limit']) and $featureValue['limit'] < 0): ?>
                                                           <?php echo e(__tr('Unlimited')); ?>

                                                       <?php elseif(isset($featureValue['limit'])): ?>
                                                           <?php echo e($featureValue['limit']); ?>

                                                           <?php if(isset($featureValue['limit_duration'])): ?>
                                                                <?php echo e(($featureValue['limit_duration'])); ?>

                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                        <?php echo e(($featureValue['description'])); ?>

                                                        </div>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="text-lg mt-4">
                                                        <?php $__currentLoopData = $charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itemKey => $itemValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php
                                                                if(!$itemValue['enabled']) {
                                                                    continue;
                                                                }
                                                            ?>
                                                            <?php if($planSelectorId !== $planId . '___' . $itemKey): ?>
                                                                <div class="my-2 text-primary">
                                                                    <input x-model="selectedPlanFrequencyNew" type="radio" name="plan"
                                                                        id="<?php echo e($planId); ?><?php echo e($itemKey); ?>"
                                                                        value="<?php echo e($planId); ?>___<?php echo e($itemKey); ?>">
                                                                    <label for="<?php echo e($planId); ?><?php echo e($itemKey); ?>">
                                                                        <?php echo e(formatAmount($itemValue['charge'], true)); ?> / <?php echo e($planStructure[$planId]['charges'][$itemKey]['title'] ?? $itemKey); ?>

                                                                </div>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </fieldset>
                                            </div>
                                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                   </div>
                                   <?php if($hasPlansForPurchase): ?>
                                   <?php if($existingManualSubscriptionPendingRequest): ?>
                                   <div class="alert alert-danger my-5">
                                    <?php echo e(__tr('Your already have pending request for manual subscription, please wait once it get confirmed')); ?>

                                   </div>
                                   <?php else: ?>
                                   <?php if(getAppSettings('enable_stripe') and $isValidStripeKeys): ?>
                                   <fieldset>
                                        <legend for="card-element">
                                            <i class="fab fa-cc-stripe"></i> <?php echo e(__tr('Auto Subscription - Credit or Debit card')); ?>

                                        </legend>
                                        <form action="<?php echo e(route('subscription.write.create')); ?>" method="post" id="payment-form"  data-secret="<?php echo e($intent->client_secret); ?>">
                                            <?php echo csrf_field(); ?>
                                            
                                            <input type="hidden" name="plan" x-model="selectedPlanFrequencyNew">
                                            <div id="card-element" class="rounded d-block mb-3 border p-3 col-sm-6 bg-white">
                                                <!-- A Stripe Element will be inserted here. -->
                                            </div>
                                            <!-- Used to display form errors. -->
                                            <div id="card-errors" role="alert" class="alert alert-danger d-none"></div>
                                            <button type="submit" class="mt-4 btn btn-primary">
                                                <?php echo e(__tr('Subscribe Now')); ?>

                                            </button>
                                    </form>
                                    </fieldset>
                                    <?php endif; ?>
                            <fieldset>
                                 <!--  ----------- This form for New Subscription -------------  -->
                               <legend><?php echo e(__tr('Manual/Prepaid Subscription')); ?></legend>
                               <?php if($isExtendedLicence): ?>
                                 <form action="<?php echo e(route('vendor.subscription_manual_pay')); ?>" method="post" id="manual-pay-form">
                                    <?php echo csrf_field(); ?>
                                    
                                    <input type="hidden" name="selected_plan" x-model="selectedPlanFrequencyNew">
                                     
                                     <?php if(getAppSettings('enable_paypal')): ?>
                                     <label for="lPaypalPaymentOption" class="mr-4"><h3><input type="radio" id="lPaypalPaymentOption" name="payment_method" value="paypal"><img height="100" src="<?php echo e(asset('imgs/pay_pal.png')); ?>"> </h3></label>
                                    <?php endif; ?>
                                    
                                    
                                    <?php if(getAppSettings('enable_razorpay')): ?>
                                        <label for="lwRazorpayPaymentOption" class="mr-4"><h3><input type="radio" id="lwRazorpayPaymentOption" name="payment_method" value="razorpay"><img height="40" src="<?php echo e(asset('imgs/razorpay.png')); ?>"> </h3></label>
                                    <?php endif; ?>
                                    
                               
                               <?php if(getAppSettings('enable_upi_payment')): ?>
                                    <label for="lwUpiPaymentOption" class="mr-4"><h3><input type="radio" id="lwUpiPaymentOption" name="payment_method" value="upi"> <?php echo e(__tr('Pay with any UPI')); ?> <img height="100" src="<?php echo e(asset('imgs/upi-icon.png')); ?>"> </h3></label>
                               <?php endif; ?>
                                
                                 
                               <?php if(getAppSettings('enable_bank_transfer')): ?>
                                    <label for="lwBankTransferPaymentOption" class="mr-4"><h3><input type="radio" id="lwBankTransferPaymentOption" name="payment_method" value="bank_transfer"> <?php echo e(__tr('Pay with Bank Transfer')); ?> <img height="100" src="<?php echo e(asset('imgs/bank-transfer.svg')); ?>"> </h3></label>
                               <?php endif; ?>
                               
                                 
                                 <?php if(getAppSettings('enable_paystack')): ?>
                                 <label for="lwPaystackPaymentOption" class="mr-4"><h3><input type="radio" id="lwPaystackPaymentOption" name="payment_method" value="paystack"><img src="<?php echo e(asset('imgs/paystack-icon.png')); ?>" height="100"> </h3></label>
                             <?php endif; ?>
                             
                                
                                <?php if(getAppSettings('enable_yoomoney')): ?>
                            
                                <label for="lwYooMoneyPaymentOption" class="mr-4"><h3><input type="radio" id="lwYooMoneyPaymentOption" name="payment_method" value="yoomoney"><img height="100" width="90" src="<?php echo e(asset('imgs/yoomoney.png')); ?>"> </h3></label>
                                <?php endif; ?>
                               
                               <div class="my-3">
                                <hr>
                                <button type="submit" class="btn btn-primary btn-lg " href=""><?php echo e(__tr('Continue')); ?></button>
                               </div>
                                </form>
                                <?php else: ?>
                                <div class="alert alert-light">
                                    <?php echo e(__tr('Not available, please contact administrator')); ?>

                                </div>
                                <?php endif; ?>
                                 <!--  ----------/New Subscription -------------  -->
                            </fieldset>
                            <?php endif; ?>
                               <?php else: ?>
                               <div class="alert alert-warning">
                                   <?php echo e(__tr('No plans to subscribe')); ?>

                               </div>
                               <?php endif; ?>
                       </div>
                   </div>
           </div>
               <?php endif; ?>
               <?php if(getAppSettings('enable_stripe') and getAppSettings('stripe_enable_invoice_list') and $isValidStripeKeys): ?>
               <div class="card mt-4">
                <div class="card-header">
                    <?php echo e(__tr('Stripe Invoices')); ?>

                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table mt-4 table-striped" id="invoicesTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__tr('Number')); ?></th>
                                    <th><?php echo e(__tr('Date')); ?></th>
                                    <th><?php echo e(__tr('Total')); ?></th>
                                    <th><?php echo e(__tr('Invoice Download')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($invoice->number); ?></td>
                                    <td><?php echo e($invoice->date()->toDayDateTimeString()); ?></td>
                                    <td><?php echo e($invoice->total()); ?></td>
                                    <td><a
                                            href="<?php echo e(route('subscription.read.download_invoice', [$invoice->id])); ?>"><?php echo e(__tr('Download')); ?></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php endif; ?>
           </div>
       </div>
   </div>
   <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php if(!isset($message)): ?>
<?php $__env->startPush('appScripts'); ?>
<script>
    $(document).ready(function() {
    'use strict';
    $('#invoicesTable').DataTable({
            ajax:false,
            serverSide: false,
            // "ordering": false,
            "order": [[ 1, "desc" ]],
            processing: false,
            formatNumber: function (numberValue) {
                return __Utils.formatAsLocaleNumber(numberValue);
            },
        });
    } );
</script>
<?php if(getAppSettings('enable_stripe') and $isValidStripeKeys and !$existingManualSubscriptionPendingRequest): ?>
    <?php if(!$currentPlan and $hasPlansForPurchase): ?>
    <script src="https://js.stripe.com/v3/"></script>
    <?php endif; ?>
    <script>
        (function(){
        'use strict';
        <?php if(!$currentPlan and $hasPlansForPurchase): ?>
        var stripe = Stripe('<?php echo e(config("cashier.key")); ?>');
        // Create an instance of Elements.
        var elements = stripe.elements({locale: '<?php echo e(app()->getLocale()); ?>'});
        // Custom styling can be passed to options when creating an Element.
        // (Note that this demo uses a wider set of styles than the guide below.)
        var style = {
            base: {
                color: '#898d05',
                fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                fontSmoothing: 'antialiased',
                fontSize: '16px',
                '::placeholder': {
                    color: '#aab7c4'
                }
            },
            invalid: {
                color: '#fa755a',
                iconColor: '#fa755a'
            }
        };

        // Create an instance of the card Element.
        var card = elements.create('card', {
            style: style
        });

        // Add an instance of the card Element into the `card-element` <div>.
        card.mount('#card-element');
        // Handle real-time validation errors from the card Element.
        card.on('change', function(event) {
            var displayError = document.getElementById('card-errors');
            if (event.error) {
                displayError.textContent = event.error.message;
            } else {
                displayError.textContent = '';
            }
        });

        // Handle form submission.
        var form = document.getElementById('payment-form'),
            cardHolderName = document.getElementById('cardholder-name'),
            clientSecret = form.dataset.secret;

        form.addEventListener('submit', async function(event) {
            event.preventDefault();
            if ($(form).serializeArray().length < 2) {
                showWarnMessage('<?php echo e(__tr('Please select plan first')); ?>');
                return;
            }
            // check if has required information
            <?php if(!getVendorSettings('city') or !getVendorSettings('country_code') or !getVendorSettings('address') or !getVendorSettings('postal_code') or !getVendorSettings('state') or !getVendorSettings('contact_email') or !getVendorSettings('contact_phone')): ?>
                showAlert("<?php echo e(__tr('Please check that you have fulfilled business information in General settings like address, city etc')); ?>", 'error');
                __Utils.throwError("<?php echo e(__tr('Missing business information.')); ?>");
            <?php endif; ?>

            const {
                setupIntent,
                error
            } = await stripe.confirmCardSetup(
                clientSecret, {
                    payment_method: {
                        card,
                         billing_details: {
                             "address": {
                                    "city": "<?php echo e(getVendorSettings('city')); ?>",
                                    "country": "<?php echo e(getVendorSettings('country_code')); ?>",
                                    "line1": "<?php echo e(getVendorSettings('address')); ?>",
                                    // "line2": null,
                                    "postal_code": "<?php echo e(getVendorSettings('postal_code')); ?>",
                                    "state": "<?php echo e(getVendorSettings('state')); ?>"
                                },
                                "email": "<?php echo e(getVendorSettings('contact_email')); ?>",
                                name: "<?php echo e(getUserAuthInfo('profile.full_name')); ?>",
                                "phone": "<?php echo e(getVendorSettings('contact_phone')); ?>"
                         }
                    }
                }
            );

            if (error) {
                // Inform the user if there was an error.
                var errorElement = document.getElementById('card-errors');
                errorElement.textContent = error.message;
                showAlert(error.message, "error");
            } else {
                // Send the token to your server.
                stripeTokenHandler(setupIntent);
            }
        });

        // Submit the form with the token ID.
        function stripeTokenHandler(setupIntent) {
            // Insert the token ID into the form so it gets submitted to the server
            var form = document.getElementById('payment-form');
            var hiddenInput = document.createElement('input');
            hiddenInput.setAttribute('type', 'hidden');
            hiddenInput.setAttribute('name', 'paymentMethod');
            hiddenInput.setAttribute('value', setupIntent.payment_method);
            form.appendChild(hiddenInput);
            // Submit the form
            form.submit();
        }
        <?php endif; ?>
    })();
    </script>
     <?php endif; ?>
<?php $__env->stopPush(); ?>
<?php endif; ?>
<?php echo $__env->make('layouts.app', ['title' => __tr('My Subscription')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/imqsvuod/wala.guru/wbiz/resources/views/vendor/subscription.blade.php ENDPATH**/ ?>