<?php $translationLanguages = getActiveTranslationLanguages();
$configCurrentLocale = app()->getLocale();
?>
<!-- Language Menu -->
<?php if(!__isEmpty($translationLanguages) and (count($translationLanguages) > 1)): ?>
<li class="nav-item dropdown no-arrow">
    <a class="nav-link dropdown-toggle" href="#" id="translationMenuDropdown" role="button" data-bs-toggle="dropdown"
        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        <span class="d-md-inline-block">
            <?php echo e(isset($translationLanguages[$configCurrentLocale]) ? $translationLanguages[$configCurrentLocale]['name'] : ''); ?>

        </span>
        &nbsp; <i class="fas fa-language"></i>
    </a>
    <ul class="dropdown-menu dropdown-menu-right dropdown-menu-end shadow animated--grow-in" aria-labelledby="translationMenuDropdown">
        <li class="dropdown-item dropdown-header text-gray disabled">
            <?php echo e(__tr('Choose your language')); ?>

        </li>
        <li class="dropdown-divider"></li>
        <?php foreach ($translationLanguages as $languageId => $language) {
            if (($languageId == $configCurrentLocale) or (isset($language['status']) and $language['status'] == false)) continue;
        ?>
        <li><a class="dropdown-item lw-ajax-link-action" data-show-processing="true" href="<?php echo e(route('locale.change', ['localeID' => $languageId])); ?>"><?php echo e($language['name']); ?></a></li>
        <?php } ?>
    </ul>
</li>
<?php endif; ?>
<!-- Language Menu --><?php /**PATH /home/sms9/public_html/resources/views/layouts/navbars/locale-menu.blade.php ENDPATH**/ ?>